
## 3 Semantics Of Solp Programs

In this section we introduce the Social Semantics**, i.e. the semantics of a collection** of SOLP programs. We assume that the reader is familiar with the basic concepts of logic programming (Gelfond and Lifschitz 1991; Baral 2003).

We start by introducing the notion of interpretation for a single SOLP program.

An interpretation for a ground (SOLP)4 program P **is a subset of** Var (P**), where**
Var (P) is the set of atoms appearing in P. A positive literal a **(resp. a negative**
literal not a**) is** true w.r.t. an interpretation I if a ∈ I (resp. a ∈/ I**); otherwise it is**
false**. A rule is** true w.r.t. I **if its head is true or its body is false w.r.t.** I.

Recall that, for each traditional logic program Q**, the** immediate consequence operator TQ is a function from 2Var(Q)to 2Var(Q) **defined as follows. For each**
interpretation I ⊆ Var (Q), TQ (I**) consists of the set of all heads of rules in** Q
whose bodies are true w.r.t. I. An interpretation I **is a** fixpoint **of a logic program**
Q if I is a fixpoint of the associated transformation TQ , i.e., if TQ (I) = I.

The set of all fixpoints of Q **is denoted by** FP(Q).

Before defining the intended models of our semantics, we need some **preliminary**
definitions.

Let P **be a SOLP program. We define the** autonomous reduction of P**, denoted**
by A(P), the program obtained from P **by removing all the SCs from the rules** in P. The intuitive meaning is that in case the program P **represents the social** behaviour of an agent, then A(P**) represents the behaviour of the same agent in** case he decides to operate independently of the other agents. Definition 4 Autonomous immediate consequence operator, applied to the SOLP **program** P
Given a SOLP program P **and an interpretation** I ⊆ Var (A(P)), let TR(A(P**)) be**
the set of tolerance rules in A(P**) and** Var ∗(A(P**)) be the set** Var (A(P))\{**okay**(p) | okay(p) ∈ Var (A(P))} ∪ {p | **okay**(p) ∈ Var (A(P))}**. The** autonomous immediate consequence operator ATP is the function from 2Var∗(A(P)) to 2Var∗(A(P))**, defined**
as follows:
ATP (I) = {head(r ) | r ∈ A(P) \ TR(A(P)) ∧ body(r ) is true w.r.t. I } ∪
{a | head(r ) = okay(a) ∧ r ∈ TR(A(P)) ∧ (body(r ) ∧ a**) is true w.r.t.** I }.

Observe that ATP , when applied to an interpretation I**, extends the classical**
immediate consequence operator TP **, by collecting not only heads of non-tolerance**
rules whose body is true w.r.t. I, but also each atom a **occurring as** okay(a**) in the**
head of some rule such that both a **and the rule body are true w.r.t.** I. Definition 5 An interpretation I for a SOLP program P **is an** autonomous fixpoint of P if I is a fixpoint of the associated transformation ATP , i.e. if ATP (I) = I**. The set of all**
autonomous fixpoints of P **is denoted by** AFP(P).