# Constructing Folksonomies From User-Specified Relations On Flickr

Anon Plangprasopchok and Kristina Lerman USC Information Sciences Institute 4676 Admiralty Way, Marina del Rey, CA 90292
{plangpra,lerman}@isi.edu Abstract. Many social Web sites allow users to publish content and annotate with descriptive metadata. In addition to flat tags, some social Web sites have recently began to allow users to organize their content and metadata hierarchically. The social photosharing site Flickr, for example, allows users to group related photos in sets, and related sets in collections. The social bookmarking site Del.icio.us similarly lets users group related tags into bundles. Although the sites themselves don't impose any constraints on how these hierarchies are used, individuals generally use them to capture relationships between concepts, most commonly the broader/narrower relations. Collective annotation of content with hierarchical relations may lead to an emergent classification system, called a folksonomy. While some researchers have explored using tags as evidence for learning folksonomies, we believe that hierarchical relations described above offer a high-quality source of evidence for this task.

We propose a simple approach to aggregate shallow hierarchies created by many distinct Flickr users into a common folksonomy. Our approach uses statistics to determine if a particular relation should be retained or discarded. The relations are then woven together into larger hierarchies.

Although we have not carried out a detailed quantitative evaluation of the approach, it looks very promising since it generates very reasonable, non-trivial hierarchies. Key words: Folksonomies, Taxonomies, Collective Knowledge, Social Information Processing, Data Mining

## 1 Introduction

The subject of automatic taxonomy creation has attracted much attention from the academic community because of its close ties to important topics in philosophy, cognitive and computer sciences, and information technology. A taxonomy is a classification system that helps people organize their knowledge of the world hierarchically through broader-narrower (superclass-subclass) relations between concepts. One of the best known taxonomies is the Linnean classification of living organisms. There are alternative classification systems for organizing knowledge that do not rely exclusively on strict hierarchies. These include faceted classification schemes, which combine multiple taxonomies to represent objects, the