various library classification schemes, such as the Dewey Decimal system, and Web directories, e.g., Yahoo directory and the Open Directory Project, which were created to categorize Web pages. Despite variations in structure, formal classification systems are distinguished by the fact that they use a *controlled* vocabulary and are created by a small group of *experts*. This means that formal classifications systems are often expensive to create and use, and it is difficult to keep them current in a fast-changing environment. Take, for example, Web directories. The first Web directory was created and is maintained by Yahoo, which hired a group of people to categorize Web pages. However, because Web changes at a rapid pace, with new pages added constantly and content of existing pages changing, it was difficult to keep the directory current. The Open Directory Project (ODP) attempted to mitigate some of these concerns by allowing a community of volunteers to edit a common Web directory. Although any user can register to become an editor, she still has to learn the structure and vocabulary and abide by the rules of the ODP.

As social Web sites, such as Flickr, Del.icio.us, and YouTube, become increasingly popular, massive amount of metadata about the content created by users is now available. The metadata comes in a variety of forms, including *tags*,
the freely-chosen keywords used to describe content, as well as links users create between content, metadata and other users. Although users annotate content for personal use, user-generated metadata can be used to discover relevant resources [1], personalize search [2], and automatically generate taxonomies [3–5].

Such a bottom-up taxonomy - a *folksonomy* - has a number of advantages over formal top-down classification systems: (1) it is dynamic, evolving in time as community's needs and vocabulary change, (2) describes facets of data that are salient to users, and (3) has a level of detail that is meaningful to users. Similar to a formal classification system, an automatically generated folksonomy could be used for information management and discovery, as well as to annotate user-generated content in order to make it machine-readable.

The current approaches to automatic folksonomy creation combine tags created by large numbers of distinct individuals by looking at statistics of their occurrence. It is possible that, because tags are flat, ambiguous and not expressive enough to annotate a large variety of content, social Web users began using inventions like colon ":" or slash "/" to combine several related keywords into a new tag. In many cases, the order of keywords glued by such separators have a meaning; for example, a preceding keyword is a superclass of the following keyword. Recognizing a demand, some social Web sites now allow users to specify some types of relations in addition to tags. Del.icio.us, for example, allows users to manually group related tags into *bundles*, while, Flickr allows users to group related photos into *sets* (similar to photo albums), and related sets into collections. Although the sites do not impose constraints on the semantics of relations expressed this way, we postulate that this type of metadata, both invented by users and available through social Web interfaces, is used to express
"broader/narrower" relationships. Users appear to categorize the content they create into shallow hierarchies, or taxonomies. We combine large numbers of