
## 4.2 Case Study

For our study, we gathered data about collection/set relations created by a set of Flickr users, identified by their ids. To gather user ids, we used the Flickr API to retrieve the names of members of seventeen public groups devoted to wildlife, specifically insect, photography. We then used a Web page scraping tool to retrieve the names of collections and sets created by these users. Although a small fraction of users created multi-level hierarchies, we only retrieved names associated with the top two levels. Of the 39, 922 users in our set, 21, 792 created at least one collection.

After processing data, we obtain 6, 871 and 7, 196 out of 213, 104 relations using hard and soft constraint respectively. The number of concepts is reduced from 94, 499 to 3, 239 and 3, 244 concepts for hard and soft constraint respectively. Top 200 concepts with high Rxoi are discarded.

The resulting graph of interlinked concepts is quite complex. To simplify browsing, we extract subgraphs associated with a concept. Starting with a given concept, we get its parents (broader concepts), and then follow the outgoing links on the graph to get the children (narrower concepts) and the children's children, etc. We illustrate the results with some sample graphs. We colored the graphs to aid visualization. The starting concept is in yellow, its parent concepts (where applicable) are in pink, while the direct descendants are in green. The rest of the descendants are in blue. The graph in Figure 3 shows the concept graph for the (stemmed) country. It has 32 children (in green), including france, china, india, uk, etc. Of the 32 children only two, florida and paris, are not proper countries. The concepts in blue are the children of the individual countries. In general, these automatically discovered concepts are quite good. For example, russia has narrower concepts moscow, st petersburg and hermitage, while england has warwick, stonehenge, and lake district, among others.

While geographical names provide a common vocabulary for labeling and organizing travel photographs, there is sufficient vocabulary agreement to induce concept graphs in many other domains. Figure 4 shows the graphs associated with (a) invertebrate and (b) vehicl. The parent concept (in pink) of invertebrate in the first graph is animal. This graph reflects the bias in our data - we collected relations from users who have posted to Flickr groups related to insect photography. These users had diverse enough interests though, and have apparently also expressed knowledge about the various modes of transportation.

The child concepts are vehicle are car, bike, truck, bicycle, motorcycle, and airplan. Not all the subsumption relations make sense, but overall, they are quite useful.

We present two more concept graphs to illustrate our method's ability to discover many relevant subcategories. Figure 5 shows the graph associated with the concept vertebrate, which includes bird and many concepts corresponding to specific types of birds. Similarly, sport graph shows many specific types of sports. Our algorithm associated france with sport, maybe because of the popular 'tour de france'. However, all other discovered subsumption relations are correct.