Programs CSI-102 and CSI-103 are perhaps clearer than CSI-101 in having a more balanced subdivision. For CSI-102, we would put this subdivision as from scenes 1 to 20; 21 to 26; 27 to 31; and 32 to 37. For CSI-103, we would demarcate the plot into scenes 1 to 19; (20 or) 21 to 29; and 30 to 38.

As in section 5.3, we looked at the characteristics of style in the scripts. For a given script, we characterized it on the basis of our nine attributes. Then we randomized the order of the scenes comprising the script. So the plot (or story) was identical in terms of the scenes that constitute it. But the plot was lacking in sense - in style and in structure - to the extent that the scenes were now in a random order. Such a randomized plot was also characterized on the basis of our nine attributes. We carried out 999 such randomizations. When an attribute's value for the real script was found to be less than or greater than 80% of the randomized plots, then we report it in Table 2. Our significance threshold of 80% was set at this value to be sufficiently decisive. It was rounded to an integer percentage in all cases.

In regard to Table 2 we recall from section 5.3 that attributes 1 and 2 are first and second moments, respectively, of relative movement from one scene to the next. Attributes 3 and 4 are first and second moments of relative orientation from one scene to the next. Attributes 5 and 6 relate to tempo. Attributes 7, 8 and 9 relate to rhythm.

Furthermore whether our script is less than or greater than the randomized alternatives - cf. column 3 of Table 2 - can be understood as follows. If the "less than or equal to" case applies we can view this as our script being more compact or more parsimonious or more smooth or low frequency, for the particular attribute at issue, relative to the great bulk of randomized alternatives.

Where the "greater than or equal to" case applies, then we can see something exceptional in the way that the plot is handled.

In Table 2, attribute 1 (mean relative movement) is a strong characterizing marker for all scripts, save one. This attribute is "compact" for the real script
(in the sense in which we have used this term of "compact" in the last paragraph, with reference to column 3 of Table 2). Attribute 3 (mean relative reorientation) is a good characterizing marker for four of the six scripts. Attribute 9 (rhythm) is also a good marker for three of the six scripts.

Our Monte Carlo procedure is a rigorous one for assessing significance of patterns in the filmscript data. As we have demonstrated it allows us to validate unique semantic properties underlying the "sensory surface" (McKee) of the filmscripts.

## 7 Conclusions

The basis for accessing semantics in provided by (i) Correspondence Analysis, where each scene is an average of words or other attributes that characterize it, and each attribute is an average of scenes that are characterized; and (ii) in the hierarchical clustering of the sequence of scenes, relative change is modeled by the dendrogram structure.