
## Hierarchical Clustering

Background on the theory and practice of hierarchical clustering can be found in [17, 18]. For the particular hierarchical clustering algorithm used here, based on the given sequence of observations, [17] should be referred to. A short description follows.

Consider the projection of observation i onto the set of all factors indexed by α, {Fα(i)} for all α, which defines the observation i in the new coordinate frame.

This new factor space is endowed with the (unweighted) Euclidean distance, d. We seek a hierarchical clustering that takes into account the observation sequence, i.e. observation i precedes observation i 0for all *i, i*0 ∈ I. We use the linear order on the observation. Let us switch to the term *texts* now, which is what our observations refer to in this work. We refer to "adjacent" texts when one follows the other with respect to this linear order, and this definition of adjacency is extended to allow for adjacent clusters of texts.

The agglomerative hierarchical clustering algorithm is as follows.

1. Consider each text in the sequence of texts as constituting a singleton cluster. Determine the closest pair of adjacent texts, and define a cluster from them.

2. Determine and merge the closest pair of adjacent clusters, c1 and c2, where closeness is defined by d(c1, c2) = max {dii0 such that i ∈ c1, i0 ∈ c2}.
3. Repeat step 2 until only one cluster remains.

Here we use a complete link criterion which additionally takes account of the adjacency constraint imposed by the sequence of texts in set I. It can be shown (see [17]) that the closeness value, given by d, at each agglomerative step is strictly non-decreasing. That is, if cluster c3 is formed earlier in the series of agglomerations compared to cluster c4, then the corresponding distances will satisfy dc3 ≤ dc4. (d here is as determined in step 2 of the algorithm above.)

## References

[1] J.-P. Benz´ecri, L'Analyse des Donn´ees, Tome I Taxinomie, Tome II Correspondances, 2nd ed. Dunod, Paris, 1979.

[2] Y. Bestgen, Segmentation markers as trace and signal of discourse structure, Journal of Pragmatics, 29, 753–763, 1998.

[3] M. Burnett and J. Allison, Everybody Comes to Rick's, screenplay, 1940.

[4] W.L. Chafe, The flow of thought and the flow of language, In Syntax and Semantics: Discourse and Syntax, ed. by Talmy Giv´on, vol. 12, 159–181, Academic Press, 1979.