A third reason for the particular embedding used for the observations and attributes in the Euclidean factor space is that weighting of observations and attributes is handled naturally in this framework. The issue of weighting has to be addressed somehow, with one option being to treat the set (of observations or of attributes) as identically weighted, and hence of equal a priori importance.

Very often either observations or attributes follow a power law: examples of such power laws include Zipf's law (in natural language texts, the word frequency is inversely proportional to its rank), the Pareto distribution in economics, and many others [19]. Correspondence Analysis handles weighting of observations and attributes at the "core" of its algorithm [18].

Application of the power law property to social networks has included the network of movie actors [19]. As counterposed to such work, our interest is in analyzing a time series of data. The succession of scenes in a movie, or acts in a play, exemplify this.

## 4.2 Input Data Used

We take all words into account in the semi-structured texts that are provided by film (or television program) scripts. Punctuation is ignored. Upper case is converted to lower case for our purposes. Words must be at least two characters in length. Any numerical figure, or term beginning with a numerical, is ignored. We have already noted above (section 3; see also the case studies and discussion in [18]) why the use of all words in this way is, in principle, feasible and justified.

Occurrences or presence/absence data therefore are the point of departure.

Each scene is cross-tabulated by the set of all words so that, in this crosstabulation table, at the intersection of scene i and word j we have a presence (1)
or absence (0) value. To employ notions of change or proximity between scenes, we need this data to be appropriately represented in a numerically well-defined semantic space. This is provided by mapping the frequencies of occurrence data into a Euclidean space, using Correspondence Analysis.

## 4.3 Hierarchical Agglomerative Clustering Respecting Sequence

Unusually in this work, we use hierarchical clustering taking a *sequence* of film script units (e.g., scenes) into account. Our motivation is the following: large ultrametric or tree distances derived from the hierarchy have a ready interpretation in terms of *change*. A brief introduction is provided in the Appendix. A
short discussion follows.

Hierarchical clustering is carried out through a sequence of agglomerations of successive scenes or of clusters (or temporal segments or intervals) of successive scenes. Respect for the sequentiality of the scenes is ensured through the requirement that agglomerands must be adjacent. In addition to this, the least dissimilar scenes are checked, with the criterion being: merge two clusters when the *greatest* dissimilarity between cluster members (scenes) is minimal.

The least dissimilar pair of scenes, considering two potential agglomerands, is