# Feature Selection For Bayesian Evaluation Of Trauma Death Risk L. Jakaite And V. Schetinin

University of Bedfordshire/Department of Computing and Information Systems, Luton, UK
Abstract**— In the last year more than 70,000 people have** 
been brought to the UK hospitals with serious injuries. Each time a clinician has to urgently take a patient through a screening procedure to make a reliable decision on the trauma treatment. Typically, such procedure comprises around 20 tests; however the condition of a trauma patient remains very difficult to be tested properly. What happens if these tests are ambiguously interpreted, and information about the severity of the injury will come misleading? The mistake in a decision can be fatal - using a mild treatment can put a patient at risk of dying from posttraumatic shock, while using an overtreatment can also cause death. How can we reduce the risk of the death caused by unreliable decisions? It has been shown that probabilistic reasoning, based on the Bayesian methodology of averaging over decision models, allows clinicians to evaluate the uncertainty in decision making. Based on this methodology, in this paper we aim at selecting the most important screening tests, keeping a high performance. We assume that the probabilistic reasoning within the Bayesian methodology allows us to discover new relationships between the screening tests and uncertainty in decisions. In practice, selection of the most informative tests can also reduce the cost of a screening procedure in trauma care centers. In our experiments we use the UK Trauma data to compare the efficiency of the proposed technique in terms of the performance. We also compare the uncertainty in decisions in terms of entropy.

Keywords**— Bayesian model averaging, MCMC, decision** 
tree, trauma care, feature selection.

## 1 I. Introduction

As it has been reported in [1], more than 70,000 people have been admitted into the UK hospitals with serious injuries. To make a reliable decision on the trauma treatment, a clinician has to urgently take a patient through a screening procedure which typically comprises around 20 tests [2]. 

However, the condition of a trauma patient is still very difficult to be tested properly. If the screening tests are ambiguously interpreted, and information about the severity of the injury is misleading, the mistake in a decision can be fatal; the choice of a mild treatment can put a patient at risk of dying from posttraumatic shock, while the choice of an overtreatment can also cause death [1]. How can we reduce the risk of the death caused by unreliable decisions? 

It has been shown in [3 - 6] that probabilistic reasoning, based on the Bayesian methodology of averaging over decision models, enables to evaluate the uncertainty in decision making. The use of the Bayesian Model Averaging (BMA) 
over Decision Trees (DTs) makes decision models interpretable for clinicians as shown in [7]. The Bayesian averaging over DTs (BDTs) enables to select attributes which make the most significant contribution to decisions. Within the Bayesian DTs averaging we would expect that discarding weakest attributes would improve the performance. 

However, in our experiments, we observed that the performance decreased. Obviously, we can explain that this happened because the discarded attribute was still important for a small amount of the data. If this is the case, then we can expect that the replacement of this attribute by noise will further decrease the performance. Alternatively, we can assume that the weakest attribute makes a contribution to the BMA. Would it be possible to discard the weakest attribute without decreasing the performance? If so, then we can reduce the number of screening tests required for making reliable decisions within BDT methodology.

In theory, BMA methodology is immune to overfitting problem [3]. However, in some cases, overfitting was shown to affect the BMA performance [8]. Based on these results we can assume that if the replacement of the weakest attribute by noise does not decrease the BMA performance, this attribute, making negligible contribution, provides better conditions for mitigating BMA overfitting. 

Based on these assumptions, in this paper we aim at selecting the most important screening tests, keeping the BDT 
performance high. This is important because selection of the most informative screening tests can reduce the cost of a screening procedure in trauma care centers. In our experiments we use the UK Trauma data to compare the efficiency of the proposed BMA technique in terms of the performance. We also compare the uncertainty in decisions in terms of entropy.

Section 2 of the paper describes the bases of BMA over DTs, and section 3 describes the Trauma data used for the experiments. The experimental results are presented in section 4, and section 5 concludes the paper.

II. METHODOLOGY OF BAYESIAN MODEL AVERAGING
For a DT given with parameters , the predictive distribution is written as an integral over the parameters 