4 original ensemble using all 16 input variables. The entropies in decisions are also the same. Thus from this experiment we can see that proposed technique allows us to use a reduced set of variables.

## D. Addition Of Noise To Variables

In our experiments some amount of noise added to a weak variable can provide better conditions for mitigating DTs ensemble overfitting. Therefore, we can assume that the addition of noise to all variables will further improve conditions for mitigating DTs ensemble overfitting.

To test this assumption we removed the variable 9 and added a uniform noise to the remaining 15 variables. The intensity of the noise was 0.01. Table 4 shows the performances of DT ensembles using the set of 16 variables and the set of 16\9 with the added noise compared within 5-fold cross-validation. This table shows that the performance of the DT ensemble using the set of 16\9 + noise is better on 2%, than that of the ensemble using the original 16 inputs. 

| Fold           | Trauma (16 variables)   | Trauma (16\9 variables + noise)   |            |       |
|----------------|-------------------------|-----------------------------------|------------|-------|
| Performance, % | Entropy                 | Performance, %                    | Entropy    |       |
| 1              | 84.37                   | 26.63                             | 85.93      | 26.52 |
| 2              | 79.36                   | 28.70                             | 80.95      | 30.31 |
| 3              | 84.12                   | 32.54                             | 88.88      | 32.47 |
| 4              | 88.88                   | 31.24                             | 90.47      | 32.00 |
| 5              | 88.88                   | 28.11                             | 88.88      | 32.65 |
| 85.13± 7.94    | 29.4± 4.80              | 87.03± 7.54                       | 30.8± 5.10 |       |

Thus we can see that the addition of the noise to the set of 16\9 variables allows us to exclude the weakest variable 9 and, at the same time, this enables to improve the DT ensemble performance.

## V. Conclusions & Discussion

We have expected that discarding weakest attributes can improve the performance of the BDT ensemble. However, in our experiments, the performance has oppositely decreased. We have assumed that this happened because the discarded weakest attribute was still important for a small amount of the data. Alternatively, we have assumed that the weakest attribute makes a noticeable contribution to the BDT ensemble's outcome. The question was would it be possible to discard the weakest attribute without decreasing the performance? This is important for clinical practice if the number of screening tests required for making reliable decisions within BDT methodology can be reduced.

Although BMA methodology in theory is immune to overfitting problem, in some cases, it was shown that overfitting affects the BMA performance. We have observed that the replacement of the weakest attribute by noise did not decrease the BDT performance, and therefore this attribute, making negligible contribution, provided better conditions for mitigating BDT ensemble overfitting. 

In this paper we aimed at selecting the most important screening tests, keeping the BDT performance high. In our experiments we used the UK Trauma data to compare the efficiency of the proposed technique in terms of the performance. We also compare the uncertainty in decisions in terms of entropy.

As a result we found that the proposed techniques allow clinicians to reduce number of screening tests, keeping the performance and reliability of making decisions high. The optimized solutions can reduce the cost of a screening procedure in trauma care centers.

## References

1. Royal Society for the Prevention of Accidents available at http://www.rospa.com/factsheets 2. Trauma Audit and Research Network available at http://www.tarn.ac.uk 3. Denison D, Holmes C, Malick B, Smith A (2002) Bayesian methods for nonlinear classification and regression. Willey 4. Breiman L, Friedman J, Olshen R, Stone C (1984) Classification and regression trees. Belmont, CA: Wadsworth.

5. Buntine W (1992) Learning classification trees. Statistics and Computing 2: 63-73 6. Chipman H, George E, McCullock R (1998) Bayesian CART model search, J. American Statistics, 93: 935-960 7. Schetinin V et al. (2007) Confident Interpretation of Bayesian Decision Trees for Clinical Applications. IEEE Transaction on Information Technology in Biomedicine, Volume 11, Issue 3, 312-319 8. Domingos P (2000) Bayesian Averaging of Classifiers and the Overfitting Problem, Proc. 17th International Conf. on Machine Learning, San Francisco, CA, 2000, 223-230

| Author:                                                                                                           | L Jakaite   |
|-------------------------------------------------------------------------------------------------------------------|-------------|
| Institute: University of Bedfordshire Street: Park Square City: Luton Country: UK Email: Livija.Jakaite@gmail.com |             |
