application, the operator can be sure that one part of the image as belonging to rock, and be totally doubtful on another part of the image. Classical confusion matrices suppose that the reality is perfectly known and that is rarely the case especially in image classification. We propose to graduate this difference of information by different weights corresponding to the different grades of certainty that are considered. In the confusion matrix, such weights could be integrated easily in the general sum. For example, consider three grades of certainty (sure, moderately sure and not sure), we can choose respectively the weights: 2/3, 1/2 and 1/3. If one expert labels a unit as belonging to the class 1 (e.g. **rock), with a moderate certainty, and if the**
classification algorithm finds the class 1, considering the previous given weights, the confusion matrix will be updated such as: cm11 ← cm11 + 1/**2. If the**
classification algorithm finds the class 2 (e.g. **sand)**
on the considered unit, the confusion matrix becomes cm12 ← cm12 + 1/**2. Hence the sums of columns are**
not integer anymore.

In order to fuse the referenced images provided by different experts, we can compare the classified image with all the referenced images by the experts. Hence we obtain as many non-normalized confusion matrices as experts, and we can simply combine them by addition. This can be done also if the experts do not provide certainty, in such a case the weight is 1 for all units.

By the simple addition of the non-normalized confusion matrices, we weight the obtained results by the image size or the considered unit number.

In order to obtained rates, we normalize the obtained confusion matrix with equation (1) and calculate the good-classification rate vector with equation
(2) and the error classification rate vector with equation (3). Of course these rates are not percentages anymore. For instance, the good-classification rate is no longer the percentage of well classified units, because the weights given by the inhomogeneous units or by the expert certainty are rational. These newly obtained confusion matrix, good-classification rate and error classification rate give a good evaluation of classification taking into account the inhomogeneous units and certainty of the experts. This approach can be applied in every domain where we try to classify uncertain elements, and not only in image classification.

## 3 Segmentation Evaluation

Image classification provides an implicit image segmentation, the boundaries are given by the difference of classes between two adjacent tiles. A good image classification evaluation has to study this obtained image segmentation.

Many approaches can be considered in order to obtain boundaries. This is not the subject of this paper and the following segmentation evaluation can be applied to all image segmentations given by boundaries as a succession of pixels.

We propose here a linked study of one wellsegmented pixel measure and a mis-segmented pixel measure. Generally one of these measures is considered in the case with an a priori **knowledge [2, 8, 9].**
The well-segmented pixel measure is a well-detection boundary measure and the mis-segmented pixel measure is a false detection boundary measure. We show how these two measures can take into account the uncertainty of the expert on the position and existence of the boundaries, assuming that each certainty grade is represented by a weight.

## 3.1 Well-Detection Boundary Measure

First, for each found boundary pixel f, search the minimal distance df e between f **and all the boundary pixels**
provided by the expert e. Hence the pixel e is a function of f, and we should note it as ef **, but in order to**
simplify notations, it is referred to as e **in the rest of** the paper. We take here an Euclidean distance but any other distance can be envisaged. The certainty weight of the pixel e given by the expert is noted as We**. We**
define a well-detection criterion vector by:

$$D C_{f}=\exp(-(d_{f e}.W_{e})^{2}).W_{e}.$$
$$\left(4\right)$$
2).We. (4)
This criterion gives a Gaussian-kind distribution of

![0_image_0.png](0_image_0.png)

weights with a standard deviation given by the certainty weights, as shown in figure 2.

The well-detection boundary measure is defined by the normalized well-detection criterion given by:

$$W D C={\frac{\sum_{f}D C_{f}}{\left(\operatorname*{max}_{f}(D C_{f})\cdot\sum_{e}W_{e}\right)^{a}}}.\qquad\qquad(5)$$

Hence, this measure is defined between 0 and 1. In real applications, this criterion remains small even for very good boundary detection, so we can take a = 1/**6 in** order to accentuate small values.

This criterion only takes into account the distance from the found boundary to the contour provided by the expert. However, the reference boundary has a local direction **which is another aspect we have to consider. Indeed, for instance, a found boundary can cross**
a given boundary orthogonally: in this case some pixels from the found boundary are very near (in terms of distance) to pixels from the reference boundary but that is not a good detection.