
## 1.2.2 Ontology And Knowledge Management

The definition of ontology by Gruber (1993) [13] is "explicit specifications of a shared conceptualization". A *conceptualization* is an abstract model of facts in the world by identifying the relevant concepts of the phenomenon. *Explicit* means that the type of concepts used and the constraints on their use are explicitly defined. 

Shared reflects the notion that an ontology captures consensual knowledge, that is, it is not private to the individual, but accepted by the group. 

Basically, the role of ontology in the knowledge management process is to facilitate the construction of a domain model. It provides a vocabulary of terms and relations in a specific domain. In building a knowledge management system, we need two types of knowledge [14]: 
Domain knowledge: Knowledge about the objective realities in the domain of interest (Objects, relations, events, states, causal relations, etc. that are obtained in some domains) 
Problem-solving knowledge: Knowledge about how to use the domain knowledge to achieve various goals. This knowledge is often in the form of a problem-solving method (PSM) that can help achieve the goals in a different domain. 

In this study, we focus on ontology creation and representation by adopting knowledge engineering methodology to support both dimensions of knowledge. 

We use the ontology as a main mechanism to represent information and knowledge, and to define the meaning of terms used in the content language and the relation in the knowledge management system. 

## 1.3 Methodology

Our proposed methodology divides ontology into three types: generic ontology, domain ontology and task ontology. *Generic ontology* is the ontology which is reuseable across the domain, e.g. organization, product specification, contact, etc. 

Domain ontology is the ontology defined for conceptualizing on the particular domain, e.g. handicraft business, logistic, import/export, marketing, etc. *Task* ontology is the ontology that specifies terminology associated with the type of tasks and describes the problem solving structure of all the existing tasks, e.g. paper production, product shipping, product selection, etc. 

In our approach to implement ontology-based knowledge management, we integrated existing knowledge engineering methodologies and ontology development processes. We adopted CommonKADS for knowledge engineering methodology and OnToKnowledge (OTK) methodology for ontology development. Figure 1.3 shows the assimilation of CommonKADS and On-ToKnowledge (OTK) [15]. 