# The Role Of Artificial Intelligence Technologies In Crisis Response

Khaled M. Khalil, M. Abdel-Aziz, Taymour T. Nazmy & Abdel-Badeeh M. Salem Faculty of Computer and Information Science, Ain shams University Cairo, Egypt kmkmohamed@gmail.com, mhaziz@aucegypt.edu, ntaymoor@yahoo.com, absalem@asunet.shams.edu.eg Abstract: **Crisis response poses many of the most difficult information technology in crisis management. It requires** 
information and communication-intensive efforts, utilized for reducing uncertainty, calculating and comparing costs and benefits, and managing resources in a fashion beyond those regularly available to handle routine problems. In this paper, we explore the benefits of artificial intelligence technologies in crisis response. This paper discusses the role of artificial intelligence technologies; namely, robotics, ontology and semantic web, and multi-agent systems in crisis response. 

Keywords: *crisis response, crisis management, artificial intelligence technology.* 

## 1.0 Introduction

Crisis events, like the 9.11 attack, Hurricane Katrina and the tsunami devastation, have dramatic impact on human society, economy and environment. The crisis response term is defined as the immediate protection of property and life during the crises events to reduce deaths and injuries. Crisis response requires urgent action and the coordinated application of resources, facilities, and efforts. It includes actions taken before the actual crisis event (e.g., hurricane warning is received), in response to the immediate impact of a crisis, and as sustained effort during the course of the crisis. Depending upon the magnitude and complexity of the crisis, response may be a large-scale and multiorganizational operation involving many layers of authorities, commercial entities, volunteer organizations, media organizations, and the public. These entities work together as a virtual organization to save lives, preserve infrastructure and community resources, and reestablish normalcy within the community [1]. Artificial intelligence technology tries to improve the efficiency of the management process during the crisis response via: robotics sustaining urban search and rescue operations [12], enhancing information sharing using ontologies [5], providing customized query to crisis actors 
[3], and providing multi-agent systems for real time support [15] and simulated environments [8]. We will discuss these technologies and those roles in crisis response. 

First, the diversity structure of crisis area, rescuers safety and the necessity of quickly and reliably examining targeted regions forces rescue agencies to use multi-robot solutions in the field of urban search and rescue. Robots provide variety of functions in the crisis context, such as area exploration, mapping and expediting the search for victims. One of the first uses was "VGTV and MicroTracs" robots, which are used during the World Trade Center crisis in New York [12] to search for victims under collapsed buildings. Successively, aerial robots ("T-Rex helicopter" from Like90) are used at Hurricane Katrina and boat robots ("AEOS-1") are used at Hurricane Wilma. 

Second, from the point of view of information processing, the success of crisis response largely depends on gathering information from distributed sources, integrating it and then making decisions. It is clear that such complexity makes it impossible for any single human or even a team to fulfill the roles adequately [3]. Ontologies and semantic web are adopted to solve integrating problems, for example ontologies are used in integrating heterogeneous information sources and semantic web services are used to provide customized queries to crisis actors. The World Wide Web Consortium (W3C) [4] and E-response project represent the noticeable effort in the way of building crisis response ontologies and getting the benefits of semantic web services. W3C focused on identifying and building standard ontology for crisis response, while E-response project focused on building overall crisis response ontology and semantic web services based on the created ontologies. 

Third, crisis response problems are not solvable by single responder and a heterogeneous team is needed. 

Heterogeneous team needs planning and coordination capabilities to complete his mission successfully. A multi-agent system provides the decisive solution to all problems related to interaction and coordination of response teams. Related multi-agent systems for crisis response include real-time support and simulation systems such as DrillSim [8], DEFACTO [15] and WIPER [14]. 

In the following sections we discuss in details artificial intelligence technologies: robots, ontologies and semantic web, and multi-agent systems contributions in crisis response. 