
## 2.0 Robotics

Robotics is a growing research area in crisis response. Multi-robot solutions had been adopted in a wide range of crisis response operations. Specifically, robots are used in Urban Search and Rescue (USAR) operations. Urban Search and Rescue involves locating, rescuing, and medically stabilizing victims trapped in confined spaces. USAR workers have 48 hours to find trapped survivors in a collapsed structure; otherwise the likelihood of finding victims still alive is nearly zero. Greer [7] had summarized challenges that USAR team have to overcome into four areas, (1) efficient response, (2) rescuers safety, (3) environment disturbance and climatic conditions, and (4) inappropriate equipment and resources. Buildings debris prevents rescue workers from searching due to the unacceptable personal risk from further collapse, besides collapse confined create spaces which are frequently too small for people to enter limiting the search to no more than a few feet from the exterior. Rescuers may be crushed by structural collapse or may be suffered respiratory injuries due to hazardous materials, fumes and dust. The site needs to be shored up and made safe for rescuers to enter which takes up three to four critical early hours of the crisis which are crucial for finding victims alive. Robots can bypass the danger and expedite the search for victims immediately after a collapse. Their ability to navigate through tightly confined spaces which people cannot access makes them extremely useful for quickly getting to a location within the crisis site. Robots can be deployed to a large crisis to search multiple locations simultaneously to expedite the search process. They can map the area and identify the location of victims using Radio Frequency Identification (RFID) tags. During the search they can deposit radio transmitters to be able to communicate with victims, use small probes to check victim's heart rate and body temperature and supply heat source and small amounts of food and medication to sustain the survivors [12]. One of the first uses of robots in search and rescue operation was during the World Trade Center crisis in New York. Figure 1 shows VGTV and MicroTracs by Inuktun robot used in rescue operations during the World Trade Center crisis in New York [12]. Micro-VGTV or Variable Geometry Tracked Vehicle can alter its shape during operation. The tracks, in their lowered configuration, take the shape of conventional crawler tracks. When the geometry is varied to the point where the vehicle is in its raised configuration, the tracks take the shape of a triangle. This unique feature allows the vehicle to negotiate obstacles, and operate in confined spaces and over rough terrain. 

![0_image_0.png](0_image_0.png)

![0_image_1.png](0_image_1.png)

 Figure 1: The Micro VGTV System Figure 2: Representative snapshot of USARSim MicroTracs 
Urban rescue and search simulation (USARSim) plays another vital role in crisis response. USARSim is a benchmark for evaluating robot platforms for their usability in crisis response. USARSim framework provides a development, testing and competition environment that is based on a realistic depiction of conditions after a real crisis, such as an earthquake or a major fire. Robots are simulated on the sensor and actuator level based on social behavior, making a transparent migration of code between real robots and their simulated counterparts possible, Figure 2 for example, a real robot may be exploring environment in cooperation with a virtual robot. The robots share map information and even see each other in their own respective representations of the real or virtual worlds. 

## 3.0 Ontology And Semantic Web

Information management and processing in crisis response aimed to produce digital representations for a common response operational picture. This common picture cannot be effective without overcoming the following challenges 
[9]: (1) Diversity of information sources: information relevant to decision making may be dispersed from sensors where data is generated, to heterogeneous databases belonging to autonomous organizations. In addition, critical information may span various modalities, e.g., voice conversations among crisis responders, cameras data, sensor data streams, GIS(Geographical Information Systems)-oriented data and relational information in databases, (2) Diversity of information users: different people/organizations have different needs and urgency levels regarding the same information. According to theses challenges different sorts of data are used, but a common core set may be shared throughout. This common core set of information can be represented by ontology. 

 
According to W3C [4] definition of crisis response ontology, crisis response ontology must describe the following critical steps: 
- Once crisis is widely anticipated, sharing of data describing response and resource characteristics are needed. 