The Semantic web vision of a crisis system that could answer a complicated request at the time of a crisis is far from realized. For example, if an emergency officer needed enough tents and food for 3400 people, deliverable in one day, first by air to the local city, then by road to the crisis area accompanied by fifteen distribution experts, the parts of this request would need at present to be broken into separate items. The required number of tents and amount of food would have to be computed, the location of the items discovered, and the logistics put in place. This would be done by building an ontology allowing machine inference in this domain [6]. 

## 4.0 Multi-Agent Systems

A multi-agent system (MAS) is a system composed of multiple interacting intelligent software agents. Multi-agent systems can be used to solve problems which are difficult or impossible for an individual agent to solve such as crisis response, and modeling social structures. Currently, multi-agent architecture is the essence of response systems. The original idea comes out from agent characteristics in MAS, such as autonomy, local view of environment, and capability of learning, planning, coordination and decentralized decision making. If we imagine that an agent can represent a crisis responder, so we can build a crisis response system based on agents' interaction and coordination. Agents can help crisis responders doing their planning, and coordination tasks or even replacing human in information gathering and specific decision making tasks. Another important research field in crisis response is the agent-based modeling and simulation, which are currently used for responders training and systems testing. DrillSim [8], DEFACTO [15] and WIPER [14] are examples of multi-agent systems for crisis response. We will discuss each system in brief, and table 1 includes comparison of the three systems: 
(1) DrillSim is an augmented reality multi-agent simulation environment for testing IT solutions. The purpose of this environment is to play out a crisis response activity where agents might be either computer agents or real people playing diverse roles. An activity in DrillSim occurs in a hybrid world that is composed of (a) the simulated world generated by a multi-agent simulator and (b) a real world captured by a smart space. In order to capture real actors in the virtual space, DrillSim utilizes a sensing infrastructure that monitors and extracts information from real actors that is needed by simulator (such as agent location, agent state, etc.); in other words, DrillSim infuses actions and state of human actors in the virtual space. DrillSim modeled agent behavior (Figure 4) as a discrete process where agents alternate between sleep and awake states. Agents wake up and take some action every t time units. For this purpose, an agent acquires awareness of the world around it (i.e. event coding), transforms the acquired data into information, and makes decisions based on this information. Then, based on the decisions, it (re)generates a set of action plans. These plans dictate the actions the agent attempts before going to sleep again. For example, hearing a fire alarm results in the decision of exiting a floor, which results in a navigation plan to attempt to go from the current location to an exit location and force the agent trying to walk one step following the navigation plan. (2) DEFACTO (Demonstrating Effective Flexible Agent Coordination of Teams through Omnipresence) incorporates 

![0_image_0.png](0_image_0.png) state of the art artificial intelligence, 3D visualization and human-interaction reasoning into a unique high fidelity system for training responders. By providing the responders interaction with the coordinating agent team in a complex environment, the responder can gain experience and draw valuable lessons that will be applicable in the real world. The DEFACTO system achieves this via (Figure 5): (i) omnipresent viewer - intuitive interface, (ii) and flexible interaction between the responder and the team. First, the 3D visualization interface enables human virtual omnipresence in the environment, improving human situational awareness and ability to assist agents. Second, generalizing past work on adjustable autonomy, the DEFACTO agent team chooses among a variety of "team-level" interaction strategies, even excluding humans from the loop in extreme circumstances. DEFACTO is comprised of various transfer-of-control strategies. Each transfer-of-control strategy is a preplanned sequence of actions to transfer control over a decision among multiple entities, for example, an ATH1H2 strategy implies that a team of agents (AT**) attempts a decision and if it** fails in the decision then the control over the decision is passed to a human H1, and then if H1 **cannot reach a decision,** then the control is passed to H2.