mass on the union. For example, if three experts say A ∪ B,
A ∪ C, D, two experts agree on A. So, it could be better to transfer the mass on A and A ∪ B ∪ C ∪ D.

Consider M experts, we define the set of subsets of the responses of the experts that are not in conflict:

$$\begin{array}{c}{{\varepsilon_{k}(Y_{1},...,Y_{M})=\{\{Y_{i_{1}},...,Y_{i_{k}}\},i_{j}\in I:}}}\\ {{I\subset\{1,...,M\},|I|=k,\cap_{j=1}^{k}Y_{i_{j}}\neq\emptyset\},}}\end{array}$$

j=1Yij 6= ∅},(33)
where Yiis the response of the expert i. Additionally, we define k **= argmax**k
{εk 6= ∅}. In the previous example, εk =
ε3 = {{A ∪ B, A ∪ **C, A** ∪ D}}.

In the M case experts, we define δ(Z) for all Z ∈ εk with Z = {Yi1**, ..., Y**ik
} as:

$$\delta(Z)=1-\frac{|\cap_{j=1}^{\overline{{k}}}Y_{i_{j}}|}{\operatorname*{min}_{j\in\{1,\ldots,\overline{{k}}\}}|Y_{i_{j}}|}.$$
. (34)
An extended mixed rule for M experts can be written:

$$m_{\rm EMix}(X)=\sum_{Y_{1}\sqcup...\sqcup Y_{M}=X}\sum_{Z\in\epsilon_{\overline{K}}(Y_{1},...,Y_{M})}\delta(Z)\prod_{j=1}^{M}m_{j}(Y_{j})$$ $$+\sum_{\{Y_{1},...,Y_{\overline{K}}\}=Z\in\epsilon_{\overline{K}}(Y_{1},...,Y_{M})}\frac{(1-\delta(Z))}{|\epsilon_{\overline{K}}(Y_{1},...,Y_{M})|}\prod_{j=1}^{M}m_{j}(Y_{j}).\tag{35}$$

This rule keep the spirit of the mixed rule. Nevertheless, imagine a very high mass on D compared to the masses on A∪B and A∪C in the previous example. Therefore, we would prefer transfer the mass proportionally on D and on the other connected elements A ∪ B and A ∪ C in the spirit of **DPCR**.

For the mass allocated on these connected elements, we can apply the extended mixed rule **EMix**. Consequently, in the case of conflict between all the experts, we must find which experts are in conflict together, *e.g.* the connected responses of the experts. This partial conflict is more precise than the partial conflict provided considering all the responses of the experts. Thus, we obtain an extended **MDPCR**.

To compute εk taking into account M focal classes having at most a size |Θ| = n, we have to read all the focal classes, and count how often each singleton appears in the focal classes:
O(nM) operations. For each of these singletons, we might have to distribute a part of the local conflict over k focal classes. Each M-uple of focal elements can request a treatment of O(n 2M2) operations, as k 6 M and |εk | 6 n. If each belief function has p focal elements, global complexity is bounded by O(n 2M2pM).

Figure 1 shows two sets of four focal elements with an empty intersection. In the left situation, each singleton is an intersection of two focal elements, and every intersection of three focal elements is ∅. So k is 2, and ε2 is {{A ∪ **B, B** ∪
C}, {B ∪ C, C ∪ D}, {C ∪ D, A ∪ D}, {A ∪ **B, A** ∪ D}}.

In the right situation, A appears in three focal elements, B in two, and the other singletons appear only in one focal element.

So k is 3, and ε3 is {{A ∪ B, A ∪ C A ∪ D}}. The singleton E does not receive any part of the conflict due to its presence

![0_image_0.png](0_image_0.png)

$$(33)$$

in the focal element B ∪ E, but only through its presence in the disjunction of all the focal elements: A ∪ B ∪ C ∪ D ∪ E.

## V. Conclusions

$$(34)$$

In this paper, we propose some solutions to deal with the conflict and to weigh the imprecision of the responses of the experts, from the classical combination rules. Thus, we first consider a mixed rule provided by a weighted sum of the conjunctive and disjunctive rules. The weights are defined from a measure of nonspecifity calculated by the cardinality of the responses of the experts. This rule transfers the partial conflict on partial ignorance. Again, the proportional conflict distribution rule redistributes the partial conflict on the element implied in this conflict. We propose an extension of this rule by a discounting procedure, thereby, a part of the partial conflict is also redistributed on the partial ignorance. So as to quantify this part, we introduce a measure of conflict between pair of experts and another measure of non-conflict between pair of experts. In order to take heed of the nonspecifity and to redistributed the partial conflict, we propose a fused rule of these two new rules. This new rule is made in such way that we retain a kind of continuity of the mass on the partial ignorance, between both cases with and without partial conflict. Finally, we propose to discuss a more general rule that can deal with the nonspecifity of each response of the expert also in the case with partial conflict between some partition of the experts.

The comments of these new rules show that the classical combination rules in the belief functions theory cannot take precisely into account the nonspecifity of the experts and the partial conflict of the experts. We can introduce more and more artificial -or not- measures of imperfections (conflict, nonspecificity, and so on) in the conjunctive and disjunctive combination rules. Another point to treat in a futur work is how these rules perform in pratical applications.

## Vi. Appendix - **Mdpcr** Algorithm

Formula (32), like most of the formula of this article, seems simpler when expressed through an algorithm instead of a direct expression of m(X). We list all the M-uples of focal elements of the M belief functions.

An input belief function e is an association of a list of focal elements and their masses. We write **size(**e) the number of its focal elements. The focal classes are e[1], e[2], . . . , e**[size(**e)]. The mass associated to a class c is e(c), written with parenthesis. The cardinality of a focal element e[i] is also written **size(**e[i]).