
## 4.2 Stability Of Decision Process

The space where experts can define their opinions on which n **classes are present**

$$..,x_{n})\in\mathrm{{I\!R}}/\sum_{i=1}^{n}x_{i}$$

in a given tile is a part of [0, 1]n: E **= [0**, 1]n ∩
(
(x1**, ..., x**n) ∈ IR/Xn i=1 xi ≤ 1
)
.

In order to study the different combination rules, and the situations where they differ, we use a Monte Carlo method, considering the masses given on **each** class (
X
aX**) by each expert, as uniform variables, filtering them by the condition**
X∈Θ
aX ≤ **1 for one expert.**
Thus, we measure the proportion of situations where decision differs between the conjunctive combination rule, and the PCR, where conflict is proportionally distributed.

We can not choose A ∩ B, as the measure of A ∩ B **is always lower (or equal**
with probability 0) than the measure of A or B**. In the case of two classes,** A∪B
is the ignorance, and is usually excluded (as it always maximizes bel, pl, **betP,** Bel, Pl and GPT). We restrict the possible choices to singletons, A, B**, etc.**
Therefore, it is equivalent to tag the tile by the most credible class (maximal for bel), the most plausible (maximal for pl), the most probable (maximal for betP) or the heaviest (maximal for m**), as the only focal elements are singletons,**
Θ and ∅.

The only situation where the total order induced by the masses m **on singletons can be modified is when the conflict is distributed on the singletons, as**
is the case in the PCR method.

Thus, for different numbers of classes, the decision obtained by fusing the experts' opinions is much less stable:
number of classes 2 3 4 5 6 7 decision change in the two experts case PCR/DST 0.61% 5.51% 9.13% 12.11% 14.55% **16.7%** PCR/DP 0.61% 2.25% 3.42% 4.35% 5.05% **5.7%** DP/DST 0.00% 3.56% 6.19% 8.39% 10.26% **11.9%** decision change in the three experts case PCR6/DST 1.04% 8.34% 13.90% 18.38% 21.98% **25.1%** PCR6/DP 1.04% 5.11% 7.54% 9.23% 10.42% **11.3%** DP/DST 0.00% 4.48% 8.88% 12.88% 16.18% **19.0%**
Therefore, the specificity of PCR6 appears mostly with more than two classes, and the different combination rules are nearly equivalent when decision must be taken within two possible classes.

For two experts and two classes, the mixed rule (DP) and the conjunctive rule (DST) are equivalent. For three experts, we use the generalized PCR6 (18).

The percentage of decision differences defines a distance between **fusion**
methods: d(PCR6,DST) ≤ d(PCR6,DP) + d(DP,DST). The two other triangular inequalities are also true. As we have d(P CR6, DST ) ≥ d**(PCR6,DP)**
and d(PCR,DST) ≥ d**(DP,DST) for any number of experts or classes, we can** conclude that the mixed rule lies between the PCR6 method and the conjunctive rule.

The figure 1 shows the density of conflict within E**. The left part shows the**
conflict for two random experts and a number of classes of 2, 3 or 7. Plain lines