Transformation. **Like the negation view for Boolean variables, minus views for**
integer variables help to derive propagators following simple transformations: for example, min(x, y) = z can be derived from max(x, y) = z **by using minus views** for x, y**, and** z.

Transformations through minus views can improve performance in subtle ways. Consider a bounds(Z**) consistent propagator for multiplication** x × y =
z**. Propagation depends on whether zero is still included in the domains** of x, y, or z**. Testing for inclusion of zero each time the propagator is executed** is not very efficient. Instead, one would like to rewrite the propagator to special variants where x, y, and z **are either strictly positive or negative. These variants** can propagate more efficiently, in particular because propagation can easily be implemented to be idempotent (see Section 7). Implementing three different propagators (all variables strictly positive, x or y strictly positive, only z **strictly** positive) seems excessive. Here, a single propagator assuming that all views are positive is sufficient, the others can be derived using minus views.

Generalization. **Offset and scale views are useful for generalizing propagators.**
Generalization has two key advantages: simplicity and efficiency. A more specialized propagator is often simpler to implement than a generalized version.

The possibility to use the specialized version when the full power of the general version is not required may save space and time during execution.

The propagator for a linear equality constraint Pn i=1 xi = c **is efficient for the**
common case that the linear equation has only unit coefficients. The more general case Pn i=1 aixi = c can be derived by using scale views for ai on xi **(This of**
course also holds true for linear inequality and disequality rather than equality).

Similarly, a propagator for alldifferent(xi**) can be generalized to alldifferent(**ci +
xi) by using offset views for ci ∈ Z on xi**. Likewise, a propagator for the element**
constraint hc1, . . . , cni[x] = y can be generalized to hc1, . . . , cni[x + o] = y **with**
an offset view, where o ∈ Z **provides a useful offset for the index variable** x.

It is important to recall that propagators are derived: in Gecode, **the above** generalizations are applied to domain as well as bounds complete propagators.

Specialization. We employ constant views **to specialize propagators. A constant view behaves like a fixed variable. In practice, specialization has two advantages: Fewer variables are needed, which means less space consumption. And**
specialized propagators can be compiled to more efficient code, if constants are known at compile time.

Examples for specialization are a propagator for binary linear inequality x +
y ≤ c derived from a propagator for x + y + z ≤ c **by using a constant 0 for** z; a Boolean propagator for x ∧ y ↔ 1 from x ∧ y ↔ z **and constant 1 for**
z; a propagator for the element constraint hc1, . . . , cni[y] = z **derived from a**
propagator for hx1, . . . , xni[y] = z; a reified propagator for (x = c) ↔ b **from** (x = y) ↔ b and a constant c for y**; a propagator for counting** |{i | xi = y}| = c from a propagator for |{i | xi = y}| = z**; and many more.**
We have to extend our model to support constant views. Propagators may now be defined with respect to a superset of the variables, Var ′ ⊇ Var . A