constant view for the value k on a variable z ∈ Var ′\ Var **translates between**
the two sets of variables as follows:

$$\begin{array}{c}{{\varphi^{-}(c)=\left\{a_{\mid V a r}\mid a\in c\right\}}}\\ {{\varphi(c)=\left\{a[k/z]\mid a\in c\right\}}}\end{array}$$

Here, a[k/z] means augmenting the assignment a so that it maps z to k**, and**
a|Var is the functional restriction of a to the set Var **. It is important to see that**
this definition preserves failure: if a propagator returns a failed domain d **that** maps z **to the empty set, then** ϕ
−(d**) is the empty set, too.**
Indexicals. **Views that perform arithmetic transformations are related to indexicals [3, 13]. An indexical is a propagator that prunes a single variable and is**
defined in terms of range expressions. A view is similar to an indexical with a single input variable. However, views are not used to build propagators directly, but to derive new propagators from existing ones. Allowing the full expressivity of indexicals for views would imply giving up our completeness results.

Another related concept are arithmetic expressions, which can be **used for**
modeling in many systems (such as ILOG Solver [10]). In contrast to views, these expressions are not used for propagation directly and, like indexicals, yield no completeness guarantees.

## 6 Set Variables: Channeling

Set constraints deal with variables whose domains are sets of finite **sets. This** powerset lattice is a Boolean algebra, so typical constraints are constructed from the Boolean primitives disjunction (union), conjunction (intersection), and negation (complement), and the relations equality and implication (subset).

Transformation and Specialization. **As for Boolean and integer variables,**
views on set variables enable transformation and specialization. Using complement views (analogous to Boolean negation) on x, y, z **with a propagator for**
x ∩ y = z yields a propagator for x ∪ y = z. A complement view on y **gives us** x\y = z**. Constant views like the empty set or the universe enable specialization;** for example, x∩y = z implements set disjointness if z **is the constant empty set.**
Channeling views. **A channeling view changes the type of the values that a**
variable can take. Our model already accommodates for this as a view ϕx **maps**
elements between different sets Val and Val′.

An important channeling view is a singleton view **on an integer variable** x, defined as ϕx(v) = {v}**. It presents an integer variable as a singleton set variable.**
Many useful constraints involve both integer and set variables, and some of them can be expressed with singleton views. The simplest constraint is x ∈ y**, where** x is an integer variable and y **a set variable. Singleton views let us implement it as**
{x} ⊆ y**, and just as easily give us the negated and reified variants. Obviously,** this extends to {x} ⋄ y **for all other set relations** ⋄.