Singleton views can also be used to derive pure integer constraints from set propagators. For example, the constraint same([x1, . . . , xn], [y1, . . . , ym**]) states**
that the two sequences of integer variables take the same values. **With singleton**
views, Sn i=1{xi} =
Sm j=1{yj} **implements this constraint.**
Channeling between domain implementations. **Most systems approximate finite set domains as convex sets defined by a lower and an upper bound [7].**
However, Hawkins et al. [8] introduced a complete representation for the domains of finite set variables using ROBDDs. Channeling views can translate between interval- and ROBDD-based implementations. We can derive **a propagator on ROBDD-based variables from a set-interval propagator, and thus reuse**
set-interval propagators for which no efficient ROBDD representation exists.

## 7 Extended Properties Of Derived Propagators

This section discusses how views can be composed, how derived propagators behave with respect to idempotence and subsumption, and how events can be used to schedule derived propagators. Finally, we discuss the relation between views and path consistency.

Composing views. **A derived propagator permits further derivation:** ϕb(ϕb′(p))
for two views ϕ, ϕ′is perfectly acceptable, properties like correctness and completeness carry over. For instance, we can derive a propagator for x−y = c **from**
a propagator for x + y **= 0 by combining an offset view and a minus view on** y.

Idempotent propagators. A propagator is idempotent iff p(p(d)) = p(d**) for**
all domains d**. Some systems require all propagators to be idempotent, others**
apply optimizations if the idempotence of a propagator is known [11]. If a propagator is derived from an idempotent propagator, the result is idempotent again:
Theorem 6. If p(p(d)) = p(d) for a propagator p and a domain d**, then, for any**
view ϕ, ϕb(p)(ϕb(p)(d**)) =** ϕb(p)(d). 

Proof. Function composition is associative, so we can write ϕb(p)(ϕb(p)(d**)) as**
ϕ
− ◦p◦(ϕ◦ϕ
−)◦p◦ϕ(d**). We know that** ϕ◦ϕ
− **= id for all domains that contain**
only assignments on which ϕ
− **is fully defined, meaning that** |ϕ
−(d)| = |d|**. As we**
first apply ϕ**, this is the case here, so we can remove** ϕ◦ϕ
−**, leaving** ϕ
−◦p◦p◦ϕ(d).

As p **is idempotent, this is equivalent to** ϕ
− ◦ p ◦ ϕ(d) = ϕb(p)(d).

Subsumption. A propagator is subsumed for a domain d **iff for all stronger**
domains d
′ ⊆ d, p(d
′) = d
′. Subsumed propagators do not contribute any propagation in the remaining subtree of the search, and can therefore **be removed.**
Deciding subsumption is coNP-complete in general, but for most propagators an approximation can be decided easily. This can be used to optimize propagation.

Theorem 7. p is subsumed by ϕ(d) iff ϕb(p**) is subsumed by** d. 