
## 8 Limitations

Although views are widely applicable, they are no silver bullet. This section explores some limitations of the presented architecture.

Beyond injective views. **Views as defined in this paper are required to be**
injective. This excludes some interesting views, such as a view for the absolute value of a variable, or a view of a variable modulo some constant. None **of the** basic proofs makes use of injectivity, so non-injective views can be **used to derive** (bounds) complete, correct propagators.

However, event handling changes when views are not injective:

- **A domain change event on a variable does not necessarily translate to a**
domain change event on the view. For instance, given a domain d with d(x) = {−1, 0, 1}, removing the value −1 from x is a domain change event on x**, but** not on abs(x).

- **A domain change event on a variable may result in a value event on the**
view. For instance, removing 0 instead of −**1 in the above example results** in d(x) = {−1, 1}, but in abs(x**) there is only a single value left.**
These effects may lead to unnecessary propagtor invocations, or **even to incorrect behavior if a propagator relies on the accuracy of the reported event.**
As propagators in Gecode may assume that events are crisp in this sense, we decided not to allow non-injective views.

Multi-variable views. **Some multi-variable views that seem interesting for**
practical applications do not preserve contraction, for instance **a view on the** sum or product of two variables. The reason is that removing a value **through**
the view would have to result in removing a tuple **of values from the actual**
domain. As domains can only represent cartesian products, this is not possible in general. For views that do not preserve contraction, Theorem 7 **does not hold.**
That means that a propagator p **cannot easily detect subsumption any longer,**
as it would have to detect it for ϕb(p) instead of just for itself, p**. In Gecode,**
propagators report whether they are subsumed, so that they are not considered for propagation again. This optimization is vital for performance, so we only allow contraction-preserving views.

For contraction-preserving views on multiple variables, all our theorems still hold. Some useful views we could identify are

- A set view of Boolean variables [b1, . . . , bn], behaving like {i | bi = 1}.

- An integer view of Boolean variables [b1, . . . , bn], where bi**is 1 iff the integer**
has value i.

- **The inverse views of the two views above.**
These views are of limited use, and the decomposition approach will probably work just as well in these cases.