
| Variable type Generic propagators Derived propagators Ratio Integer 69 230 3.34 Boolean 23 72 3.13 Set 24 114 4.75 Overall 116 416 3.59   |
|-------------------------------------------------------------------------------------------------------------------------------------------|

Propagator invariants. **Propagators typically rely on certain invariants of a**
variable domain implementation. If idempotence or completeness of a **propagator** depend on these invariants, channeling views lead to problems, as the actual variable implementation behind the view may not respect the same invariants.

For example, a propagator for interval-based finite set variables can assume that adjusting the lower bound of a variable does not affect its upper bound. If this propagator is instantiated with a channeling view for an ROBDD-based set variable, this invariant is violated: if, for instance, the current **domain is** {{1, 2}, {3}}**, and you add 1 to the lower bound, the 3 is removed from the** upper bound (in addition to 2 being added to the lower bound). A propagator that relies on the invariant may lose idempotence.

## 9 Experiments

Our experiments in [12] showed that deriving propagators using views incurs no runtime overhead. Here, we present empirical evidence for two more facts: views are highly applicable in real-world constraint programming systems, and they are clearly superior to a decomposition-based approach.

Applicability. The Gecode C++ **library [5] makes heavy use of views. Table 2**
shows the number of generic propagators implemented in Gecode, and the number of derived instances. On average, every generic propagator **results in 3.59**
propagator instances. Propagators in Gecode account for more **than 40 000 lines**
of code and documentation. As a rough estimate, generic propagators with views save around 100 000 lines of code and documentation to be written, **tested, and** maintained. On the other hand, the views are implemented in less than **8 000** lines of code, yielding a 1250% return on investment.

Views vs. decomposition. **In order to relate derived propagators to arc and**
path consistency, Sect. 7 decomposed a derived propagator ϕb(p**) into additional**
variables and propagators for the individual ϕx and p**. Of course, one has to ask**
why we advertise variable views instead of always using decomposition. Table 3 shows the runtime and space requirements of several benchmarks implemented in Gecode. The numbers were obtained on a Intel Pentium IV at 2.8 GHz **running** Linux and Gecode 2.1.1. The figures illustrate that derived propagators clearly outperform the decomposition, both in runtime and space.