
| Benchmark                                                 | derived   | decomposed   |        |        |
|-----------------------------------------------------------|-----------|--------------|--------|--------|
| time (ms) space (kB) relative time (%) relative space (%) |           |              |        |        |
| Alpha                                                     | 91.25     | 83.22        | 405.62 | 167.32 |
| Eq-20                                                     | 1.37      | 70.03        | 613.61 | 219.95 |
| Queens 100                                                | 24.72     | 2 110.00     | 705.10 | 103.03 |
| Golf 8-4-9                                                | 310.40    | 10 502.00    | 211.47 | 231.64 |
| Steiner triples 9                                         | 135.72    | 957.03       | 108.38 | 100.03 |

Table 3. **Runtime and space comparison: derived propagators vs. decomposition**

## 10 Conclusion And Future Work

The paper has developed variable views as a technique to derive perfect propagator variants. Such variants are ubiquitous, and the paper has **shown how**
to systematically derive propagators using techniques such as transformation, generalization, specialization, and channeling.

We have presented a model of views that allowed us to prove that derived propagators are indeed perfect: they inherit correctness and domain completeness from their original propagator, and preserve bounds completeness given additional properties of views.

As witnessed by the empirical evaluation, deriving propagators saves huge amounts of code to be written and maintained in practice, and is clearly superior to decomposing constraints into additional variables and simple propagators.

For future work, it will be interesting to investigate how views can be **generalized, even if that means that derived propagators are not perfect any more.**
Acknowledgements. **We thank Mikael Lagerkvist and Gert Smolka for fruitful**
discussions about views and helpful comments on a draft of this paper.

## References

1. K. Apt. *Principles of Constraint Programming***. Cambridge University Press, 2003.**
2. F. Benhamou. Heterogeneous Constraint Solving. In *Proceedings of the fifth International Conference on Algebraic and Logic Programming (ALP'96)***, volume 1139**
of *LNCS***, pages 62–76. Springer, 1996.**
3. M. Carlsson, G. Ottosson, and B. Carlson. An open-ended finite domain constraint solver. In H. Glaser, P. H. Hartel, and H. Kuchen, editors, *Programming Languages:* Implementations, Logics, and Programs, 9th International *Symposium, PLILP'97*,
volume 1292 of *LNCS***, pages 191–206, Southampton, UK, 1997. Springer.**
4. C. W. Choi, W. Harvey, J. H. M. Lee, and P. J. Stuckey. Finite **domain bounds**
consistency revisited. In A. Sattar and B.-H. Kang, editors, AI 2006: Advances in Artificial Intelligence**, volume 4304 of** *LNCS***, pages 49–58. Springer, 2006.**
5. Gecode: Generic constraint development environment, 2008. Available as an opensource library from www.gecode.org.

6. I. P. Gent, C. Jefferson, and I. Miguel. Watched literals for constraint propagation in Minion. In F. Benhamou, editor, *Twelfth International Conference on Principles*