the massive use of views in Gecode, it is vital to develop a model that allows us to prove that derived propagators have the desired properties.

In this paper, we argue that propagators that are derived using variable views are indeed perfect**: they are not only perfect for performance, we prove that they**
inherit all essential properties such as correctness and completeness from their original propagator.

Last but not least, we show common techniques for deriving propagators with views and demonstrate their wide applicability. In Gecode, every propagator implementation is reused 3.**6 times on average. Without views, Gecode would** feature 140 000 rather than 40 000 lines of propagator implementation to be written, tested, and maintained.

Variable views. Consider a bounds consistent propagator for max(x, y) = z.

Assume that x (x**) returns the maximum (minimum) of the finite domain variable** x, whereas x ← n (x ← n**) adjusts the maximum (minimum) value of** x to min(x, n) (max(x, n**)), only taking variable bounds into account. The propagator** is implemented by performing the following operations on its variables:

## X ← Z Y ← Z Z ← Max(X, Y) Z ← Max(**X, Y**)

Given three more propagators for x
′ = −x, y
′ = −y**, and** z
′ = −z**, we could**
propagate the constraint min(x
′, y′) = z
′. In contrast to this **decomposition**,
we propose to use generic propagators that perform operations **on views rather**
than variables. Views provide the same interface (set of operations) as variables while enabling additional transformations. For example, an operation on a minus view x
′ on a variable x **behaves as if executed on** −x: x
′is defined as −x and x
′ ← n is defined as x ← −n**. With views, the implementation of the maximum**
propagator can be reused: we derive **a propagator for the minimum constraint**
by instantiating the maximum propagator with minus views for its variables.

The feasibility of variable views rests on today's programming languages' support for generic (or polymorphic) constructions (for example, templates in C++**) and that the simple transformations provided by views are optimized away.**
Contributions. **This paper contributes an implementation independent model**
for views and derived propagators, techniques for deriving propagators, and an evaluation that shows that views are widely applicable, drastically reduce programming effort, and are more efficient than decomposition.

More specifically, the key contribution is the identification of properties of views that are essential for deriving perfect propagators. To this end, the paper establishes a formal model that defines a view as a function and **a derived**
propagator as functional composition of views (mapping values to values) with a propagator (mapping variable domains to variable domains). This model yields all the desired results: derived propagators are indeed propagators; derived propagators faithfully implement the intended constraints; domain consistency carries over to derived propagators; different forms of bounds consistency over integer variables carry over provided that the views satisfy additional properties.