Theorem 3. Views preserve contraction: for any domain d**, if** p(ϕ(d)) ⊆ ϕ(d),
then ϕb(p)(d) ⊂ d. 

Proof. **Recall the definition of** ϕ
−(c) as {a ∈ Asn | ϕAsn (a) ∈ c}**. It clearly**
follows that |ϕ
−(c)| ≤ |c|. Similarly, we know that |ϕ(c)| = |c|**. From** p(ϕ(d)) ⊂
ϕ(d), we know that |p(ϕ(d))| < |ϕ(d)|**. Together, this yields** |ϕb(p)(d)| < |ϕ(d)| =
|d|. We have already seen in Theorem 1 that ϕb(p)(d) ⊆ d**, so we can conclude** that ϕb(p)(d) ⊂ d.

Completeness. **Weak completeness, as introduced above, is the minimum required for a constraint solver to be complete. A weakly complete propagator does**
not have to prune variable domains, it only has to check if an assigned **domain** is a solution of the constraint. The success of constraint propagation however crucially depends on strong propagators that prune variable domains.

The strongest possible inference that a single propagator can do establishes domain consistency (also known as generalized arc consistency**): a domain** d is domain consistent for a constraint c, iff for all variables xi **and all values**
vi ∈ d(xi), there exist values vj ∈ d(xj ) for all other variables xj **such that the** assignment (x1 7→ v1, . . . , xi7→ vi, . . . , xn 7→ vn**) is a solution of** c.

A propagator is domain complete **(or simply complete) for a constraint** c if it establishes domain consistency. More formally, a propagator p **is complete for**
a constraint c iff for all domains d, we have p(d) ⊆ dom(c ∩ d**). A complete** propagator thus removes all assignments from d **that are inconsistent with** c.

We will now prove that propagators derived from complete propagators are also complete. In Sect. 5, we will extend this result to weaker notions of completeness, such as bounds(Z) and bounds(R**) completeness.**
For this proof, we need two auxiliary definitions. A constraint c is a ϕ constraint iff for all a ∈ c, there is a b ∈ Asn such that a = ϕAsn (b**). A view** ϕ is dom injective iff ϕ
−(dom(c**)) = dom(**ϕ
−(c)) for all ϕ **constraints** c.

For the completeness proof, we need a lemma that states that any **view is**
dom injective.

Proof. **By definition of** ϕ
− and dom(·**), we have** ϕ
−(dom(c**)) =** {a ∈
Asn | ∀x.∃b ∈ c.ϕAsn (a)(x) = b(x)}. As c is a ϕ **constraint, we can find such**
a b that is in the range of ϕAsn **, if and only if there is also a** b
′ ∈ ϕ
−(c**) such**
that ϕAsn (b
′) = b. Therefore, we get {a ∈ Asn | ∀x.∃b
′ ∈ ϕ
−(c).a(x) = b
′(x)} =
dom(ϕ
−(c)).

Furthermore, we need a lemma that states that views commute with set intersection: For any view ϕ**, the equation** ϕ
−(c1 ∩ c2) = ϕ
−(c1) ∩ ϕ
−(c2**) holds.**
Proof. **By definition of** ϕ
−**, we have** ϕ
−(c1 ∩ c2) = {a ∈ Asn | ϕAsn (a) ∈
c1 ∧ ϕAsn(a) ∈ c2}. As ϕAsn is a function, this is equal to {a ∈ Asn | ϕAsn(a) ∈ c1} ∩ {a ∈ Asn | ϕAsn(a) ∈ c2} = ϕ
−(c1) ∩ ϕ
−(c2).

Theorem 4. If p is complete for c, then ϕb(p**) is complete for** ϕ
−(c). 

