Reification. **Many reified constraints (such as (**Pn i=1 xi = c) ⇔ b**) also exist in**
a negated version (such as (Pn i=1 xi 6= c) ⇔ b**). Deriving the negated version is**
trivial by using a negation view on the Boolean control variable b**. This contrasts** nicely with the effort without views: either the entire code must be duplicated or the parts that perform checking whether the constraint or its negation is entailed must be factorized out and combined differently for the two variants.

## 5 Integer Variables: Generalization, Bounds Consistency, Specialization

Common views for finite domain integer variables capture linear transformations of the integer values. In [12], the following views are introduced for a **variable**
x and values v: a minus view on x is defined as ϕx(v) = −v, an offset view for o ∈ Z on x is defined as ϕx(v) = v +o, and a scale view for a ∈ Z on x **is defined**
as ϕx(v) = a · v.

Propagators for integer variables offer a greater degree of freedom concerning their level of completeness. While Boolean propagators most often will be domain complete, bounds completeness is important for integer propagators. Before we discuss transformation and generalization techniques for **deriving integer**
propagators, we study how bounds completeness is affected by views.

Bounds consistency and bounds completeness. **There are several different**
notions of bounds consistency in the literature (see [4] for an overview). For our purposes, we distinguish bounds(D), bounds(Z), and bounds(R**) consistency:**

- A domain d is bounds(D) consistent for a constraint c**, iff for all variables** xi there exist vj ∈ d(xj ) for all other variables xj such that {x1 7→ v1**, . . . , x**i7→ min(d(xi)), . . . , xn 7→ vn} ∈ c and analogously for xi7→ max(d(xi)).

- A domain d is bounds(Z) consistent for a constraint c**, iff for all variables**
xi, there exist integers vj with min(d(xj )) ≤ vj ≤ max(d(xj **)) for all other** variables xj such that {x1 7→ v1, . . . , xi7→ min(d(xi)), . . . , xn 7→ vn} ∈ c and analogously for xi7→ max(d(xi)).

- A domain d is bounds(R) consistent for a constraint c**, iff for all variables**
xi, there exist real numbers vj ∈ R with min(d(xj )) ≤ vj ≤ max(d(xj **)) for**
all other variables xj such that {x1 7→ v1, . . . , xi7→ min(d(xi))**, . . . , x**n 7→
vn} ∈ cR and analogously for xi7→ max(d(xi)), where cR is c **relaxed to** R
(for constraints like arithmetics where relaxation makes sense).
A propagator p is bounds(X**) complete for its associated constraint** cp, iff p(d) is bounds(X) consistent for cp for every domain d that is a fixpoint of p. We use an equivalent definition based on the strongest convex domain that contains a constraint, conv(c) = min{d ∈ Dom | c ⊆
d and d convex}**. A convex domain maps each variable to an interval, so that**
conv(c)(x) = {mina∈c(a(x)), . . . , maxa∈c(a(x))}. Note that conv(c**) is weaker**
than the strongest domain that contains c: conv(c) ⊇ dom(c**) for all constraints**
c**. In the same way as Benhamou [2] and Maher [9], we define**