# Defaults And Normality In Causal Structures Joseph Y. Halpern∗

Cornell University Dept. of Computer Science Ithaca, NY 14853 halpern@cs.cornell.edu http://www.cs.cornell.edu/home/halpern

## Abstract

A serious defect with the Halpern-Pearl (HP) definition of causality is repaired by combining a theory of causality with a theory of defaults. In addition, it is shown that (despite a claim to the contrary) a cause according to the HP condition need not be a single conjunct. A definition of causality motivated by Wright's NESS test is shown to always hold for a single conjunct. Moreover, conditions that hold for all the examples considered by HP are given that guarantee that causality according to (this version) of the NESS test is equivalent to the HP definition.

1 Introduction Getting an adequate definition of causality is difficult.

There have been numerous attempts, in fields ranging from philosophy to law to computer science (see, e.g., [Collins, Hall, and Paul 2004; Hart and Honor´e 1985; Pearl 2000]). A recent definition by Halpern and Pearl (HP
from now on), first introduced in [Halpern and Pearl 2001],
using structural equations, has attracted some attention recently. The intuition behind this definition, which goes back to Hume [1748], is that A is a cause of B if, had A not happened, B would not have happened. For example, despite the fact that it was raining and I was drunk, the faulty brakes are the cause of my accident because, had the brakes not been faulty, I would not have had the accident. As is well known, this definition does not quite work. To take an example due to Wright [1985], suppose that Victoria, the victim, drinks a cup of tea poisoned by Paula, but before the poison takes effect, Sharon shoots Victoria, and she dies. We would like to call Sharon's shot the cause of the Victoria's death, but if Sharon hadn't shot, Victoria would have died in any case. HP deal with this by, roughly speaking, considering the contingency where Sharon does not shoot. Under that contingency, Victoria dies if Paula administers the poison, and otherwise does not. To prevent the poisoning from also being a cause of Paula's death, HP put some constraints on the contingencies that could be considered.

Unfortunately, two significant problems have been found with the original HP definition, each leading to situations
∗
Supported in part by NSF under under grants ITR-0325453 and IIS-0534064, and by AFOSR under grant FA9550-05-1-0055.

Copyright c 2021, Association for the Advancement of Artificial Intelligence (www.aaai.org). All rights reserved.

where the definition does not match most people's intuitions regarding causality. The first, observed by Hopkins and Pearl [2003] (see Example 3.3), showed that the constraints on the contingencies were too liberal. This problem was dealt with in the journal version of the HP paper [Halpern and Pearl 2005] by putting a further constraint on contingencies. The second problem is arguably deeper.

As examples of Hall [2007] and Hiddleston [2005] show, the HP definition gives inappropriate answers in cases that have structural equations isomorphic to ones where the HP
definition gives the appropriate answer (see Example 4.1).

Thus, there must be more to causality than just the structural equations. The final HP definition recognizes this problem by viewing some contingencies as "unreasonable" or "farfetched". However, in some of the examples, it is not clear why the relevant contingencies are more farfetched than others. I show that the problem is even deeper than that: there is no way of viewing contingencies as "farfetched" independent of actual contingency that can solve the problem.

This paper has two broad themes, motivated by the two problems in the HP definition. First, I propose a general approach for dealing with the second problem, motivated by the following well-known observation in the psychology literature [Kahneman and Miller 1986, p. 143]: "an event is more likely to be undone by altering exceptional than routine aspects of the causal chain that led to it." In the language of this paper, a contingency that differs from the actual situation by changing something that is atypical in the actual situation is more reasonable than one that differs by changing something that is typical in the actual situation. To capture this intuition formally, I use a wellunderstood approach to dealing with defaults and normality [Kraus, Lehmann, and Magidor 1990]. Combining a default theory with causality, using the intuitions of Kahnemann and Miller, leads to a straightforward solution to the second problem. The idea is that, when showing that if A
hadn't happened then B would not have happened, we consider only contingencies that are more normal than the actual world. For example, if someone typically leaves work at 5:30 PM and arrives home at 6, but, due to unusually bad traffic, arrives home at 6:10, the bad traffic is typically viewed as the cause of his being late, not the fact that he left at 5:30 (rather than 5:20).

The second theme of this paper is a comparison of the