HP definition to perhaps the best worked-out approach to causality in the legal literature: the NESS (Necessary Element of a Sufficient Set) test, originally described by Hart and Honor´e [1985], and worked out in greater detail by Wright [1985, 1988, 2001]. This is motivated in part by the first problem. As shown by Eiter and Lukasiewicz [2002]
and Hopkins [2001], the original HP definition had the property that causes were always single conjuncts; that is, it is never the case that A ∧ A′is a cause of B if A 6= A′. This property, which plays a critical role in the complexity results of Eiter and Lukasiewicz [2002], was also claimed to hold for the revised definition [Halpern and Pearl 2005] (which was revised precisely to deal with the first problem) but, as I show here, it does not. Nevertheless, for all the examples considered in the literature, the cause is always a single conjunct. Considering the NESS test helps explain why.

While the NESS test is simple and intuitive, and deals well with many examples, as I show here, it suffers from some serious problems. In In particular, it lacks a clear definition of what it means for a set of events to be *sufficient* for another event to occur. I provide such a definition here, using ideas from the HP definition of causality. Combining these ideas with the intuition behind the NESS test leads to a definition of causality that (a) often agrees with the HP definition (indeed, does so on all the examples in the HP paper)
and (b) has the property that a cause is always a single conjunct. I provide a sufficient condition (that holds in all the examples in the HP paper) for when the NESS test definition implies the HP definition, thus also providing an explanation as to why the cause is a single conjunct according to the HP
definition in so many cases.

I conclude this introduction with a brief discussion on related work. There has been a great deal of work on causality in philosophy, statistics, AI, and the law. It is beyond the scope of this paper to review it; the HP paper has some comparison of the HP approach to other, particularly those in the philosophy literature. It is perhaps worth mentioning here that the focus of this work is quite different from the AI work on formal action theory (see, for example, [Lin 1995; Sandewall 1994; Reiter 2001]), which is concerned with applying causal relationships so as to guide actions, as opposed to the focus here on extracting the actual causality relation from a specific scenario.

## 2 Causal Models

In this section, I briefly review the formal model of causality used in the HP definition. More details, intuition, and motivation can be found in [Halpern and Pearl 2005] and the references therein.

The HP approach assumes that the world is described in terms of random variables and their values. For example, if we are trying to determine whether a forest fire was caused by lightning or an arsonist, we can take the world to be described by three random variables: FF for forest fire, where FF = 1 if there is a forest fire and FF = 0 otherwise; L for lightning, where L = 1 if lightning occurred and L = 0 otherwise; M for match (dropped by arsonist), where M = 1 if the arsonist drops a lit match, and M = 0 otherwise. The choice of random variables determines the language used to frame the situation. Although there is no "right" choice, clearly some choices are more appropriate than others. For example, when trying to determine the cause of Sam's lung cancer, if there is no random variable corresponding to smoking in a model then, in that model, we cannot hope to conclude that smoking is a cause of Sam's lung cancer.

Some random variables may have a causal influence on others. This influence is modeled by a set of structural equations. For example, to model the fact that if a match is lit or lightning strikes then a fire starts, we could use the random variables M , FF, and L as above, with the equation FF **= max(**L, M ). The equality sign in this equation should be thought of more like an assignment statement in programming languages; once we set the values of FF and L, then the value of FF is set to their maximum. However, despite the equality, if a forest fire starts some other way, that does not force the value of either M or L to be 1.

It is conceptually useful to split the random variables into two sets: the *exogenous* variables, whose values are determined by factors outside the model, and the *endogenous* variables, whose values are ultimately determined by the exogenous variables. For example, in the forest fire example, the variables M , L, and FF are endogenous. However, we want to take as given that there is enough oxygen for the fire and that the wood is sufficiently dry to burn. In addition, we do not want to concern ourselves with the factors that make the arsonist drop the match or the factors that cause lightning. These factors are all determined by the exogenous variables.

Formally, a *causal model* M is a pair (S, F), where S is a signature, which explicitly lists the endogenous and exogenous variables and characterizes their possible values, and F
defines a set of *modifiable structural equations*, relating the values of the variables. A signature S is a tuple (U, V, R),
where U is a set of exogenous variables, V is a set of endogenous variables, and R associates with every variable Y ∈
U ∪ V a nonempty set R(Y ) of possible values for Y (that is, the set of values over which Y *ranges*). F associates with each endogenous variable X ∈ V a function denoted FX such that FX : (×U∈UR(U)) × (×Y ∈V−{X}R(Y )) →
R(X). This mathematical notation just makes precise the fact that FX determines the value of X, given the values of all the other variables in **U ∪ V**. If there is one exogenous variable U and three endogenous variables, X, Y , and Z,
then FX defines the values of X in terms of the values of Y ,
Z, and U. For example, we might have FX(u, y, z) = u+y, which is usually written as X = U + Y .

1 Thus, if Y = 3 and U = 2, then X = 5, regardless of how Z is set.

In the running forest fire example, suppose that we have an exogenous random U that d etermines the values of L
and M . Thus, U has four possible values of the form (**i, j**),
where both of i and j are either 0 or 1. The i value determines the value of L and the j value determines the value 1Again, the fact that X is assigned U +Y (i.e., the value of X is the sum of the values of U and Y ) does not imply that Y is assigned X − U; that is, FY (**U, X, Z**) = X − U does not necessarily hold.