- ϕ is a Boolean combination of primitive events,
- Y1**, . . . , Y**k are distinct variables in V, and
- yi ∈ R(Yi).

Such a formula is abbreviated as [Y~ = ~y]ϕ. The special case where k = 0 is abbreviated as ϕ. Intuitively, [Y1 =
y1**, . . . , Y**k = yk]ϕ says that ϕ would hold if Yi were set to yi, for i = 1**, . . . , k**.

A causal formula ψ is true or false in a causal model, given a context. As usual, I write (**M, ~u**) |= ψ if the causal formula ψ is true in causal model M given context ~u. The |= relation is defined inductively. (**M, ~u**) |= X = x if the variable X has value x in the unique (since we are dealing with acyclic models) solution to the equations in M in context ~u (that is, the unique vector of values for the exogenous variables that simultaneously satisfies all equations in M with the variables in U set to ~u). The truth of conjunctions and negations is defined in the standard way. Finally,
(M, ~u) |= [Y~ = ~y]ϕ if (MY~ =~y
, ~u) |= ϕ. I write M |= ϕ if
(**M, ~u**) |= ϕ for all contexts ~u.

For example, if M is the disjunctive causal model for the forest fire, and u is the context where there is lightning and the arsonist drops the lit match, then (**M, u**) |=
[M = 0](FF **= 1)**, since even if the arsonist is somehow prevented from dropping the match, the forest burns (thanks to the lightning); similarly, (M, u) |= [L = 0](FF **= 1)**.

However, (M, u) |= [L = 0; M = 0](FF **= 0)**: if arsonist does not drop the lit match and the lightning does not strike, then the forest does not burn.

## 3.2 A Preliminary Definition Of Causality

The HP definition of causality, like many others, is based on counterfactuals. The idea is that A is a cause of B if, if A hadn't occurred (although it did), then B would not have occurred. This idea goes back to at least Hume [1748, Section VIII], who said:
We may define a cause to be an object followed by another, . . . , if the first object had not been, the second never had existed.

This is essentially the *but-for* test, perhaps the most widely used test of actual causation in tort adjudication. The butfor test states that an act is a cause of injury if and only if, but for the act (i.e., had the the act not occurred), the injury would not have occurred.

There are two well-known problems with this definition.

The first can be seen by considering the disjunctive causal model for the forest fire again. Suppose that the arsonist drops a match and lightning strikes. Which is the cause? According to a naive interpretation of the counterfactual definition, neither is. If the match hadn't dropped, then the lightning would still have struck, so there would have been a forest fire anyway. Similarly, if the lightning had not occurred, there still would have been a forest fire. As we shall see, the HP definition declares both lightning and the arsonist cases of the fire. (In general, there may be more than one cause of an outcome.)
A more subtle problem is what philosophers have called preemption, where there are two potential causes of an event, one of which preempts the other. Preemption is illustrated by the following story taken from [Hall 2004]:
Suzy and Billy both pick up rocks and throw them at a bottle. Suzy's rock gets there first, shattering the bottle. Since both throws are perfectly accurate, Billy's would have shattered the bottle had it not been preempted by Suzy's throw.

Common sense suggests that Suzy's throw is the cause of the shattering, but Billy's is not. However, it does not satisfy the naive counterfactual definition either; if Suzy hadn't thrown, then Billy's throw would have shattered the bottle.

The HP definition deals with the first problem by defining causality as counterfactual dependency *under certain* contingencies. In the forest fire example, the forest fire does counterfactually depend on the lightning under the contingency that the arsonist does not drop the match; similarly, the forest fire depends oounterfactually on the arsonist's match under the contingency that the lightning does not strike. Clearly we need to be a little careful here to limit the contingencies that can be considered. We do not want to make Billy's throw the cause of the bottle shattering by considering the contingency that Suzy does not throw. The reason that we consider Suzy's throw to be the cause and Billy's throw not to be the cause is that Suzy's rock hit the bottle, while Billy's did not. Somehow the definition must capture this obvious intuition.

With this background, I now give the preliminary version of the HP definition of causality. Although the definition is labeled "preliminary", it is quite close to the final definition, which is given in Section 4. As I pointed out in the introduction, the definition is relative to a causal model (and a context); A may be a cause of B in one causal model but not in another. The definition consists of three clauses. The first and third are quite simple; all the work is going on in the second clause.

The types of events that the HP definition allows as actual causes are ones of the form X1 = x1 ∧**. . .**∧ Xk = xk—that is, conjunctions of primitive events; this is often abbreviated as X~ = ~x. The events that can be caused are arbitrary Boolean combinations of primitive events. The definition does not allow statements of the form "A or A′is a cause of B," although this could be treated as being equivalent to
"either A is a cause of B or A′is a cause of B". On the other hand, statements such as "A is a cause of B or B′" are allowed; as we shall see, this is not equivalent to "either A
is a cause of B or A is a cause of B′".

Definition 3.1 : (Actual cause; preliminary version)
[Halpern and Pearl 2005] X~ = ~x is an *actual cause of* ϕ in (**M, ~u**) if the following three conditions hold:
AC1. (M, ~u) |= (X~ = ~x) and (**M, ~u**) |= ϕ.

AC2. There is a partition of V (the set of endogenous variables) into two subsets Z~ and W~ with X~ ⊆ Z~ and a setting ~x′and ~w of the variables in X~ and W~ , respectively, such that if (**M, ~u**) |= Z = z
∗for all Z ∈ Z~ , then both of the following conditions hold:
(a) (M, ~u) |= [X~ = ~x′, W~ = ~w]¬ϕ.