This shows that causality is not transitive, according to our definitions. Although T = 1 is a cause of TT = 0 and TT = 0 is a cause of BMC = 0 ∨ BMC = 1 ∨ BMC = 2, T = 1 is not a cause of BMC = 0∨BMC = 1∨BMC = 2.

Nor is causality closed under *right weakening*: T = 1 is a cause of BMC = 0, which logically implies BMC =
0 ∨ BMC = 1 ∨ BMC = 2, which is not caused by T = 1.

This distinguishes the HP definition from that of Lewis
[2000], which builds in transitivity and implicitly assumes right weakening.

The version of AC2(b) used here is taken from
[Halpern and Pearl 2005], and differs from the version given in the conference version of that paper
[Halpern and Pearl 2001]. In the current version, AC2(b)
is required to hold for all subsets W~ ′ of W~ ; in the original definition, it was required to hold only for W~ . The following example, due to Hopkins and Pearl [2003], illustrates why the change was made.

Example 3.3: Suppose that a prisoner dies either if A loads B's gun and B shoots, or if C loads and shoots his gun.

Taking D to represent the prisoner's death and making the obvious assumptions about the meaning of the variables, we have that D = 1 iff (A = 1 ∧ B = 1) ∨ (C **= 1)**. Suppose that in the actual context u, A loads B's gun, B does not shoot, but C does load and shoot his gun, so that the prisoner dies. Clearly C = 1 is a cause of D = 1. We would not want to say that A = 1 is a cause of D = 1 in context u; given that B did not shoot (i.e., given that B = 0), A's loading the gun should not count as a cause. The obvious way to attempt to show that A = 1 is a cause is to take W~ = {**B, C**} and consider the contingency where B = 1 and C = 0. It is easy to check that AC2(a) holds for this contingency; moreover,
(M, u) |= [A = 1, B = 1, C = 0](D **= 1)**. However,
(M, u) |= [A = 1, C = 0](D **= 0)**. Thus, AC2(b) is not satisfied for the subset {C} of W, so A = 1 is not a cause of D = 1. However, had we required AC2(b) to hold only for W~ rather than all subsets W~ ′ of W~ , then A = 1 would have been a cause.

While the change in AC2(b) has the advantage of being able to deal with Example 3.3 (indeed, it deals with the whole class of examples given by Hopkins and Pearl of which this is an instance), it has a nontrivial side effect.

For the original definition, it was shown that the minimality condition AC3 guarantees that causes are always single conjuncts [Eiter and Lukasiewicz 2002; Hopkins 2001]. It was claimed in [Halpern and Pearl 2005] that the result is still true for the modified definition, but, as I now show, this is not the case.

Example 3.4: A and B both vote for a candidate. B's vote is recorded in two optical scanners (C1 and C2). If A votes for the candidate, then she wins; if B votes for the candidate and his vote is correctly recorded in the optical scanners, then the candidate wins. Unfortunately, A also has access to the scanners, so she will set them to read 0 if she does not vote for the candidate. In the actual context ~u, both A and B vote for the candidate. The following structural equations characterize C and WIN: Ci = min(A, B), i = 1, 2, and WIN = 1 iff A = 1 or C1 = C2 = 1. I claim that C1 =
1 ∧ C2 = 1 is a cause of WIN = 1, but neither C1 = 1 nor C2 = 1 is a cause. To see that C1 = 1 ∧ C2 = 1 is a cause, first observe that AC1 clearly holds. For AC2, let W~ = {A} (so Z~ = {B, C1, C2, WIN}) and take w =
0 (so we are considering the contingency where A = 0).

Clearly, (M, ~u) |= [C1 = 0, C2 = 0, A **= 0](**WIN **= 0)** and
(M, ~u) |= [C1 = 1, C2 = 1, A = a](WIN **= 1)**, for both a = 0 and a = 1, so AC2 holds. To show that AC3 holds, I must show that neither C1 = 1 nor C2 = 1 is a cause of WIN = 1. The argument is the same for both C1 = 1 and C2 = 1, so I just show that C1 = 1 is not a cause. To see this, note that if C1 = 1 is a cause with W~ , ~w, and ~x′as witnesses, then W~ must contain A and ~w must be such that A = 0. But since (M, u) |= [C1 = 1, A **= 0](**WIN **= 0)**,
AC2(b) is violated no matter whether C2 is in Z~ or in W~ .

Although Example 3.4 shows that causes are not always single conjuncts, they often are. Indeed, it is not hard to show that in all the standard examples considered in the philosophy and legal literature (in particular, in all the examples considered in HP), they are. The following result give some intuition as to why. Further intuition is given by the results of Section 5. Notice that in Example 3.4, A affects both C1 and C2. As the following result shows, we do not have conjunctive causes if the potential causes cannot be affected by other variables.

Say that X~ = ~x is a weak cause of ϕ *under the contingency* W~ = ~w in (**M, ~u**) if AC1 and AC2 hold under the contingency W~ = ~w, but AC3 does not necessarily hold.

Proposition 3.5: If X~ = ~x *is a weak cause of* ϕ in (**M, ~u**)
with W~ , ~w, and ~x′ as witnesses, |X~ | > 1*, and each variable* Xiin X~ *is independent of all the variables in* V − X~ in ~u
(that is, if Y~ **⊆ V −** X~ , then for each setting ~y of Y~ *, we have*
(**M, ~u**) |= X~ = ~x iff (M, ~u) |= [Y~ = ~y](X~ = ~x)*), then* X~ = ~x *is not a cause of* ϕ in (**M, ~u**).

In the examples in [Halpern and Pearl 2005] (and elsewhere in the literature), the variables that are potential causes are typically independent of all other variables, so in these causes are in fact single conjuncts.

## 4 Dealing With Normality And Typicality

While the definition of causality given in Definition 3.1 works well in many cases, it does not always deliver answers that agree with (most people's) intuition. Consider the following example, taken from Hitchcock [2007], based on an example due to Hiddleston [2005].

Example 4.1: Assassin is in possession of a lethal poison, but has a last-minute change of heart and refrains from putting it in Victim's coffee. Bodyguard puts antidote in the coffee, which would have neutralized the poison had there been any. Victim drinks the coffee and survives. Is Bodyguard's putting in the antidote a cause of Victim surviving?

Most people would say no, but according to the preliminary HP definition, it is. For in the contingency where Assassin