puts in the poison, Victim survives iff Bodyguard puts in the antidote.

Example 4.1 illustrates an even deeper problem with Definition 3.1. The structural equations for Example 4.1 are *isomorphic* to those in the forest-fire example, provided that we interpret the variables appropriately. Specifically, take the endogenous variables in Example 4.1 to be A (for "assassin does not put in poison"), B (for "bodyguard puts in antidote"), and VS (for "victim survives"). Then A, B, and VS
satisfy exactly the same equations as L, M , and FF, respectively. In the context where there is lightning and the arsonists drops a lit match, both the the lightning and the match are causes of the forest fire, which seems reasonable. But here it does not seem reasonable that Bodyguard's putting in the antidote is a cause. Nevertheless, any definition that just depends on the structural equations is bound to give the same answers in these two examples. (An example illustrating the same phenomenon is given by Hall [2007].) This suggests that there must be more to causality than just the structural equations. And, indeed, the final HP definition of causality allows certain contingencies to be labeled as "unreasonable" or "too farfetched"; these contingencies are then not considered in AC2(a) or AC2(b). Unfortunately, it is not always clear what makes a contingency unreasonable. Moreover, this approach will not work to deal with Example 3.2.

In this example, we clearly want to consider as reasonable the contingency where no doctor is assigned to Billy and Billy is not treated (and thus is sick on Tuesday). We should also consider as reasonable the contingency where doctor 1 is assigned to Billy and treats him (otherwise we cannot say that doctor 1 is the cause of Billy being sick if he is assigned to Billy and does not treat him). What about the contingency where doctor i > 1 is assigned to treat Billy and does so? It seems just as reasonable as the one where doctor 1 is assigned to treat Billy and does so. Indeed, if we do not call it reasonable, then we will not be able to say that doctor i is a cause of Billy's sickness in the context where doctor i assigned to treat Billy and does not. On the other hand, if we call it reasonable, then if doctor 1 is assigned to treat Billy and does not, then doctor i > 1 not treating Billy will also be a cause of Billy's sickness. To deal with this, what is reasonable will have to depend on the context; in the context where doctor 1 is assigned to treat Billy, it should not be considered reasonable that doctor i > 1 is assigned to treat Billy.

As suggested in the introduction, the solution involves assuming that an agent has, in addition to a theory of causality
(as modeled by the structural equations), a theory of "normality" or "typicality". This theory would include statements like "typically, people do not put poison in coffee" and "typically doctors do not treat patients to whom they are not assigned". There are many ways of giving semantics to such typicality statements, including *preferential structures* [Kraus, Lehmann, and Magidor 1990; Shoham 1987],
ǫ*-semantics* [Adams 1975; Geffner 1992; Pearl 1989], and possibilistic structures [Dubois and Prade 1991], and ranking functions [Goldszmidt and Pearl 1992; Spohn 1988].

For definiteness, I use the last approach here (although it would be possible to use any of the other approaches as well).

Take a *world* to be a complete description of the values of all the random variables. I assume that each world has associated with it a *rank*, which is just a natural number or ∞.

Intuitively, the higher the rank, the less likely the world. A world with a rank of 0 is reasonably likely, one with a rank of 1 is somewhat likely, one with a rank of 2 is quite unlikely, and so on. Given a ranking on worlds, the statement
"if p then typically q" is true if in all the worlds of least rank where p is true, q is also true. Thus, in one model where people do not typically put either poison or antidote in coffee, the worlds where neither poison nor antidote is put in the coffee have rank 0, worlds where either poison or antidote is put in the coffee have rank 1, and worlds where both poison and antidote are put in the coffee have rank 2.

Take an *extended causal model* to be a tuple M =
(S, F, κ), where (S, F) is a causal model, and κ is a *ranking* function that associates with each world a rank. In an acyclic extended causal model, a context ~u determines a world denoted s~u. X~ = ~x is a cause of ϕ *in an extended model* M
and context ~u if X~ = ~x is a cause of ϕ according to Definition 3.1, except that in AC2(a), there must be a world s such that κ(s) ≤ κ(s~u) and X~ = ~x′ ∧ W~ = ~w is true at s. This can be viewed as a formalization of Kahnemann and Miller's observation that we tend to alter the exceptional than the routine aspects of a world; we consider only alterations that hold in a world that is no more exceptional than the actual world.3(The idea of extending causal models with a ranking function already appears in [Halpern and Pearl 2001], but it was not used to capture statements about typicality as suggested here. Rather, it was used to talk about X~ = ~x being a cause of ϕ *at rank* k, where k is the lowest rank of the world that shows that X~ = ~x is a cause. The idea was dropped in the journal version of the paper.)
This definition deals well with all the problematic examples in the literature. Consider Example 4.1. Using the ranking described above, Bodyguard is not a cause of Victim's survival because the world that would need to be considered in AC2(a), where Assassin poison the coffee, is less normal than the actual world, where he does not. It also deals well with Example 3.2. Suppose that in fact the hospital has 100 doctors and there are variables A1, . . . , A100 and T1, . . . , T100 in the causal model, where Ai = 1 if doctor i is assigned to treat Billy and Ai = 0 if he is not, and Ti = 1 if doctor i actually treats Billy on Monday, and Ti = 0 if he does not. Doctor 1 is assigned to treat Billy; the others are not. However, in fact, no doctor treats Billy. Further assume that typically, doctors do not treat patients
(that is, a random doctor does not typically treat a random patient), and if doctor i is assigned to Billy, then typically 3I originally considered requiring that κ(s) < κ(s~u), so that you move to a strictly more normal world, but this seems too strong a requirement. For example, suppose that A wins an election over B by a vote of 6–5. We would like to say that each voter for A is a cause of A's winning. But if we view all voting patterns as equally normal, then no voter is a cause of A's winning, because no contingency is more normal than any other.