Example 5.1: Consider Wright's example of Victoria's poisoning from the introduction. First, suppose that Victoria drinks a cup of tea poisoned by Paula, and then dies. It seems clear that Paula poisoning the tea caused Victoria's death. Let S consist of two events:

## - A1, Paula Poisoned The Tea; And

- A2, Victoria drank the tea.

Given our understanding of the world, it seems reasonable to say that the A1 and A2 are sufficient for Victoria's death, but removing A1 results in a set that is insufficient.

But now suppose that Sharon shoots Victoria just after she drinks the tea (call this event A3), and she dies instantaneously from the shot (before the poison can take effect). In this case, we would want to say that A3 is the cause of Victoria's death, not A2. Nevertheless, it would seem that the same argument that makes Paula's poisoning a cause without Sharon's shot would still make Paula's poisoning a cause even without Sharon's shot. The set {A1, A2} still seems sufficient for Victoria's death, while {A2} is not.

Wright [1985] observes the poisoned tea would be a cause of Victoria's death only if Victoria "drank the tea and was alive when the poison took effect". Wright seems to be arguing that {A1, A2} is in fact not sufficient for Victoria's death. We need A3: Victoria was alive when the poison took effect. While I agree that the fact that Victoria was alive when the poison took place is critical for causality, I
do not see how it helps in the NESS test, under what seems to me the most obvious definitions of "sufficient". I would argue that {A1, A2} is in fact just as sufficient for death as
{A1, A2, A3}. For suppose that A1 and A2 hold. Either Victoria was alive when the poison took effect, or she was not.

In the either case, she dies. In the former case, it is due to the poison; in the latter case, it is not.

But it gets worse. While I would argue that {A1, A2} is indeed just as sufficient for death as {A1, A2, A3}, it is not clear that {A1, A2} is in fact sufficient. Suppose, for example, that some people are naturally immune to the poison that Paula used, and do not die from it. Victoria is not immune. But then it seems that we need to add a condition A4 saying that Victoria is not immune from the poison to get a set sufficient to cause Victoria's death. And why should it stop there? Suppose that the poison has an antidote that, if administered within five minutes of the poison taking effect, will prevent death. Unfortunately, the antidote was not administered to Victoria, but do we have to add this condition to S to get a sufficient set for Victoria's death? Where does it stop?

I believe that a formal definition of sufficient cause requires the machinery of causal models. (This point echoes criticisms of NESS and related approaches by Pearl [2000, pp. 314–315].) I now sketch an approach to defining sufficiency that delivers reasonable answers in many cases of interest and, indeed, often agrees with the HP definition.5 5Interestingly, Baldwin and Neufeld [2003] claimed that the NESS test could be formalized using causal models, but did not actually show how, beyond describing some examples. In a later paper [Baldwin and Neufeld 2004], they seem to retract the claim that the NESS test can be formalized using causal models.

Fix a causal model M. Recall that a primitive event has the form X = x; a set of primitive events is *consistent* if it does not contain both X = x and X = x
′for some random variable X and x 6= x
′. If S = {X1 = x1**, . . . , X**k = xk}
is a consistent set of primitive events, then S is *sufficient* for ϕ relative to causal model M if M |= [S]ϕ, where [S]ϕ is an abbreviation for [X1 = x1; **. . .** ; Xk = xk]ϕ. Roughly speaking, the idea is to formalize the NESS test by taking X = x to be a cause of ϕ if there is a a set S including X = x that is sufficient for ϕ, while S − {X = x} is not.

Example 5.1 already shows that this will not work. If CP
is a random variable that takes on value 1 if Paula poisoned the tea and 0 otherwise, then it is not hard to show that in the obvious causal model, CP = 1 is sufficient for PD = 1
(Victoria dies), even if Sharon shoots Victoria. To deal with this problem, we must strengthen the notion of sufficiency to capture some of the intuitions behind AC2(b).

Say that S is *strongly sufficient for* ϕ in (**M, ~u**) if S ∪ S
′
is sufficient for ϕ in M for all sets S
′consisting of primitive events Z = z such that (**M, ~u**) |= Z = z. Intuitively, S is strongly sufficient for ϕ in (**M, ~u**) if S remains sufficient for ϕ even when additional events, which happen to be true in
(**M, ~u**), are added to it. As I now show, although CP = 1 is sufficient for PD = 1, it is not strongly sufficient, provided that the language includes enough events.

As already shown by HP, in order to get the "right" answer for causality in the presence of preemption (here, the shot preempts the poison), there must be a variable in the language that takes on different values depending on which of the two potential causes is the actual cause. In this case, we need a variable that takes on different values depending on whether Sharon shot. Suppose that it would take Victoria t units of time after the poison is administered to die; let DAP be the variable that has value 1 if Victoria dies t units of time after the poison is administered and is alive before that, and has value 0 otherwise. Note that DAP = 0 if Victoria is already dead before the poison takes effect. In particular, if Sharon shoots Victoria before the poison takes effect, then DAP = 0. Then although CP = 1 is sufficient for PD = 1, it is not strongly sufficient for PD = 1 in the context ~u′ where Sharon shoots, since (M, ~u) |= DAP = 0, and M |= [CP = 1; DAP = 0](PD 6**= 1)**.

The following definition is my attempt at formalizing the NESS condition, using the ideas above.

Definition 5.2: X~ = ~x is a *cause of* ϕ in (**M, ~u**) *according* to the causal NESS test if there exists a set S of primitive events containing X~ = ~x such that the following properties hold:
NT1. (**M, ~u**) |= S; that is, (**M, ~u**) |= Y = y for all primitive events Y = y in S.

NT2. S is strongly sufficient for ϕ in (**M, ~u**).

NT3. S−{X~ = ~x} is not strongly sufficient for ϕ in (**M, ~u**).

NT4. X~ = ~x is minimal; no subset of X~ satisfies conditions NT1–3.6 6This definition does not take into account defaults. It can be extended to take defaults into account by requiring that if ~u′is the