Nous avons montré l'intérêt de la théorie des fonctions de croyance pour la prise de décision lors de la classification d'images texturées en environnement incertain [2]. L'application visée et qui servira d'illustration dans ce papier est la caractérisation de sédiments marins à partir d'images sonar. Ce problème est particulièrement délicat car les images sonar sont souvent difficiles à interpréter, même pour un expert [1]. Sur une même imagette, il peut être préférable de décider qu'il y a par exemple du sable ou de la vase lorsque l'expert est peu sûr ou de rejeter si l'imagette correspond à une classe non apprise (telle qu'une épave) [2]. Il faudrait également pouvoir décider qu'il y a du sable et de la vase lorsque l'expert est sûr et que sur l'imagette considérée les deux sédiments apparaissent. Nous supposons donc posséder un classifieur s'exprimant par une fonction de croyance. Nous considérerons ici la combinaison de classifieurs binaires de type SVM (Support Vector Machine) présentée dans [2], d'autres approches de combinaison de classifieurs sont possibles [3, 4, 5] ou de classifieurs crédibilistes [6, 7].

Nous présentons dans la section suivante un rappel sur les fonctions de croyance et le processus de décision utilisé dans [2] permettant de décider sur les classes et les unions de classes mais aussi de rejeter des éléments. Nous étendons ensuite cette approche afin de pouvoir décider de façon simple également sur les intersections de classes. Ceci est illustré dans la section 4 pour décider à l'issue de la reconnaissance de la texture des images sonar.

## 2 Fonctions De Croyance

La théorie des fonctions de croyance est de plus en plus employée pour la modélisation des incertitudes et imprécisions. Elle est fondée sur la manipulation des fonctions de masse (ou masse élémentaire de croyance). Les fonctions de masse sont définies sur l'ensemble de toutes les disjonctions du cadre de discernement Θ = {C1**, . . . , C**n} et à valeurs dans [0, 1],
où les Ci représentent les hypothèses supposées exhaustives et exclusives. Cet ensemble est noté 2 Θ. Généralement, il est ajouté une condition de normalité, donnée par :

$$\sum_{X\in2^{\Theta}}m_{j}(X)=1,\qquad\qquad\qquad(1)$$  $m_{j}(.)$ **represente** **la** **function** **de**
masse pour une source (ou un classifieur binaire dans cet article) Sj, j = 1**, ..., s**. Ainsi selon les stratégies du passage à plusieurs classes du classifieur binaire nous avons s = n dans le cas uncontre-reste et s = n(n − 1)/2 dans le cas un-contre-un. À partir de ces fonctions de masse, d'autres fonctions de croyance peuvent être définies, telles que les fonctions de crédibilité, représentant une croyance minimale d'une source en un élément. Elles sont données pour tout X ∈ 2 Θ
par :

$$\operatorname{bel}_{j}(X)=\sum_{Y\in2^{\Theta},Y\subseteq X,Y\neq\emptyset}m_{j}(Y),\qquad(2)$$

ou encore les fonctions de plausibilité, représentant une croyance maximale d'une source en un élément, données pour tout X ∈ 2 Θ par :

$$\operatorname{pl}_{j}(X)=\sum_{Y\in2^{\Theta},Y\cap X\neq\emptyset}m_{j}(Y).\qquad\quad(3)$$

Afin de conserver un maximum d'informations, il est préférable de rester à un niveau crédal (*i.e.*
de manipuler des fonctions de croyance) pendant l'étape de combinaison des informations pour prendre la décision sur les fonctions de décision issues de la combinaison. La règle initialement proposée par Dempster, est une règle conjonctive normalisée définie pour s classifieurs, pour tout X ∈ 2 Θ r {∅} par :
avec

$$m_{\mathrm{DS}}(X)={\frac{m_{\mathrm{Conj}}(X)}{1-m_{\mathrm{Conj}}(\varnothing)}},$$
, (4)
$$m_{\mathrm{Conj}}(X)=\sum_{Y_{1}\cap\ldots\cap Y_{s}=X}\prod_{j=1}^{s}m_{j}(Y_{j}),\qquad(5)$$
$$\quad(4)$$
