
## 4.2 Modèle

Le modèle de fonctions de masse employé ici pour combiner les différents classifieurs binaires issus du SVM est celui proposé dans
[2]. Dans le cas un-contre-un considéré dans cet article, les n(n − 1)/2 fonctions de décision du classifieur sont notées fij avec **i < j**
et **i, j** = 1**, ..., n**, où i et j correspondent aux classes considérées Ci et Cj. Ainsi nous définissons la fonction de masse en sortie de chaque classifieur binaire par :

  mij (Ci)(x) = αij . (1 − exp(− 1 λij,p fij (x)))1l[0,+∞[(fij (x)) + exp(−1 λij,n fij (x))1l]−∞,0[(fij (x)) mij (Cj )(x) = αij . exp(− 1 λij,p fij (x)))1l[0,+∞[(fij (x)) (1 − exp(−1 λij,n fij (x)))1l]−∞,0[(fij (x)) mij (Θ)(x) = 1 − αij avec
$$\left\{\begin{array}{l}\lambda_{ij,p}=\frac{1}{l}\sum_{t=1}^{l}f_{ij}(x)\,\mbox{\small1\kern-2.0pt1}_{[0,+\infty[}(f_{ij}(x)),\\ \lambda_{ij,n}=\frac{1}{l}\sum_{t=1}^{l}f_{ij}(x)\,\mbox{\small1\kern-2.0pt1}_{]-\infty,0[}(f_{ij}(x)).\end{array}\right.\tag{17}$$
La règle de combinaison conjonctive normalisée (équation (4)) sera ici employée sur les n(n−1)/2 fonctions de masse du cas un-contreun. Lorsque les données sont très recouvertes, des règles répartissant le conflit plus finement doivent être privilégiés (cf. [8]).

## 4.3 Résultats Et Discussion

Dans un premier temps donnons des résultats de reconnaissance sur des imagettes homogènes. On considère 1000 imagettes pour chaque type de sédiment roche-cailloutis (C1), sable (C2),
vase (C3), et ride (C4). Les tableaux 1 et 2 donnent les résultats respectivement pour la décision pignistique et crédibilité avec rejet sur les singletons et décision selon [2] avec rejet puis sur les unions possibles. On constate tout d'abord l'intérêt du rejet, car même si une partie des imagettes des classes apprises est rejetée, la plus grande part rejetée vient des rides
(classe C4 non apprise). La part d'erreur la plus importante provient de la confusion entre sable
(C2) et vase (C3) qui sont deux sédiments de texture homogène difficile à reconnaître pour l'expert [1]. Permettre de décider sur les unions montrent bien cette difficulté : une part importante de ces imagettes de sable et vase sont classées comme sable ou vase (C2 ∪ C3). De plus le sédiment ride, s'il n'est pas rejeté, est classé en roche ou sable (C1 ∪ C2) qui correspond aux erreurs les plus commises. Les rides (de sable bien souvent) sont de texture plus ou moins hétérogène (comme la roche) et d'intensité proche du sable lorsque les rides sont peu marquées.

| pignistique   | avec rejet   |     |     |     |     |     |     |
|---------------|--------------|-----|-----|-----|-----|-----|-----|
| C1            | C2           | C3  | C1  | C2  | C3  | C4  |     |
| C1            | 867          | 131 | 2   | 825 | 73  | 2   | 100 |
| C2            | 31           | 835 | 134 | 17  | 655 | 98  | 230 |
| C3            | 9            | 348 | 643 | 4   | 216 | 590 | 190 |
| C4            | 567          | 415 | 18  | 486 | 232 | 13  | 269 |

Tableau 1 - Résultat de la décision pignistique et crédibilité avec rejet sur les singletons. Les résultats du tableau 2 sont donnés pour r = 0.5. Sur ces données homogènes, cette valeur de r est un bon compromis entre singletons et unions [2].

À présent si l'on prend la décision pignistique sur les éléments de cardinalité 4 dans DΘ, nous prenons donc la décision sur l'un des singletons ou I2 = (C1 ∩ C2) ∪ (C1 ∩ C3) ∪ (C2 ∩ C3). Le tableau 3 montre qu'on obtient exactement les mêmes résultats qu'avec la décision du maximum de crédibilité avec rejet (tableau 1). L'hypothèse de monde fermé (et donc de rejet impossible) entraîne donc ici une interprétation d'une ignorance sur 2 types de sédiments sur une imagette (I2).

Considérons maintenant des imagettes ne contenant plus un seul sédiment, mais deux.