One element X of 2Θ, such as m(X) > 0, is called *focal* element. The set of focal elements for m is noted Fm. A mass function where Θ is a focal element, is called a *non-dogmatic* mass functions.

One of the main goal of this theory is the combination of information given by many experts. When this information can be written as a mass function, many combination rules can be used [23]. The first combination rule proposed by Dempster and Shafer is the normalized conjunctive combination rule given for two basic belief assignments m1 and m2 and for all X ∈ 2 Θ, X 6= ∅ by:

$$m_{\mathrm{DS}}(X)=\frac{1}{1-k}\sum_{A\cap B=X}m_{1}(A)m_{2}(B),$$
$$\left(2\right)$$
where $k=\sum_{A\cap B=\emptyset}m_{1}(A)m_{2}(B)$ is the inconsistency of the combination.  
However the high computational complexity, especially compared to the probability theory, remains a problem for more industrial uses. Of course, higher the cardinality of Θ is, higher the complexity becomes [38]. The combination rule of Dempster and Shafer is \#P-complete [25]. Moreover, when combining with this combination rule, non-dogmatic mass functions, the number of focal elements can not decrease.

Hence, we can distinguish two kinds of approaches to reduce the complexity of the belief function framework. First we can try to find optimal algorithms in order to code the belief functions and the combination rules based on M¨obius transform [18, 33] or based on local computations [28] or to adapt the algorithms to particulars mass functions [27, 3]. Second we can try to reduce the number of focal elements by approximating the mass functions [37, 36, 4, 9, 16, 17], that could be particularly important for dynamic fusion.

In practical applications the mass functions contain at first only few focal elements [7, 1]. Hence it seems interesting to only work with the focal elements and not with the entire space 2Θ. That is not the case in all general developed algorithms [18, 33].

Now if we consider the extension of the belief function theory proposed by
[10], the mass function are defined on the extension of the power set into the hyper power set DΘ (that is the set of all the disjunctions and conjunctions of the elements of Θ). This extension can be seen as a generalization of the classical approach (and it is also called DSmT for Dezert and Smarandache Theory [29, 30]). This extension is justified in some applications such as in
[20, 21]. Try to generate DΘ is not easy and becomes untractable for more than 6 elements in Θ [11].

In [12], a first proposition have been proposed to order elements of hyper power set for matrix calculus such as [18, 33] made in 2Θ. But as we said herein, in real applications it is better to only manipulate the focal elements. Hence, some authors propose algorithms considering only the focal elements [9, 15, 22].

In the previous volume [30], [15] have proposed Matlab1codes for DSmT hybrid rule. These codes are a preliminary work, but first it is really not optimized for Matlab and second have been developed for a dynamic fusion.

Matlab is certainly not the best program language to reduce the speed of processing, however most of people using belief functions do it with Matlab.

1Matlab is a trademark of The MathWorks, Inc.