# A New Probabilistic Transformation Of Belief Mass Assignment

Jean Dezert ONERA
The French Aerospace Lab 29 Av. Division Leclerc, 92320 Chˆatillon, France.

Email:jean.dezert@onera.fr Abstract— In this paper, we propose in Dezert-Smarandache Theory (DSmT) framework, a new probabilistic transformation, called DSmP, in order to build a subjective probability measure from any basic belief assignment defined on any model of the frame of discernment. Several examples are given to show how the DSmP transformation works and we compare it to main existing transformations proposed in the literature so far. We show the advantages of DSmP over classical transformations in term of Probabilistic Information Content (PIC). The direct extension of this transformation for dealing with qualitative belief assignments is also presented.

Keywords: DSmT, Subjective probability, Probabilistic Information Content, qualitative belief.

## I. Introduction And Motivation

In the theories of belief functions, Dempster-Shafer Theory
(DST) [4], Transferable Belief Model (TBM) [11] or DSmT
[6], [7], the mapping from the belief to the probability domain is a controversial issue. The original purpose of such mappings was to make (hard) decision, but contrariwise to erroneous widespread idea/claim, this is not the only interest for using such mappings nowadays. Actually the probabilistic transformations of belief mass assignments are very useful in modern multitarget multisensor tracking systems (or in any other systems) where one deals with soft decisions (i.e.

where all possible solutions are kept for state estimation with their likelihoods). For example, in a Multiple Hypotheses Tracker using both kinematical and attribute data, one needs to compute all probabilities values for deriving the likelihoods of data association hypotheses and then mixing them altogether to estimate states of targets. Therefore, it is very relevant to use a mapping which provides a high probabilistic information content (PIC) for expecting better performances. This perfectly justifies the theoretical work proposed in this paper. A classical transformation is the so-called *pignistic probability* [10],
denoted **BetP**, which offers a good compromise between the maximum of credibility Bel and the maximum of plausibility Pl for decision-support. Unfortunately, **BetP** doesn't provide the highest PIC in general as pointed out by Sudano [12]–[14].

We propose hereafter a new generalized pignistic transformation, denoted **DSmP**, which is justified by the maximization of the PIC criterion. An extension of this transformation in the qualitative domain is also presented.

Florentin Smarandache Chair of Math. & Sciences Dept.

University of New Mexico, 200 College Road, Gallup, NM 87301, U.S.A.

Email: smarand@unm.edu

## Ii. Pignistic Probabilities

The basic idea of the pignistic transformation [9], [10]
consists in transferring the positive mass of belief of each non specific element onto the singletons involved in that element split by the cardinality of the proposition when working with normalized basic belief assignments (bba's). The (classical) pignistic probability in TBM framework is given by 1 **BetP**(∅) = 0 and∀X∈2 Θ **\ {∅}** by:

$$B e t P(X)=\sum_{Y\in2^{\Theta},Y\neq\emptyset}{\frac{|X\cap Y|}{|Y|}}{\frac{m(Y)}{1-m(\emptyset)}},\qquad\qquad(1)$$

where2 Θ is the power set of the finite and discrete frameΘ
assuming Shafer's model, i.e. all elements ofΘ are assumed truly exclusive. In Shafer's approach,m(∅) = 0 and the formula (1) can be rewritten for any singletonθi∈Θ as

$$B e t P(\theta_{i})=\sum_{\begin{subarray}{c}Y\in\mathfrak{g}^{\Theta}\\ \theta_{i}\subseteq Y\end{subarray}}{\frac{1}{|Y|}}m(Y)=m(\theta_{i})+\sum_{\begin{subarray}{c}Y\in\mathfrak{g}^{\Theta}\\ \theta_{i}\subset Y\end{subarray}}{\frac{1}{|Y|}}m(Y)\,\,\,(2)$$

This transformation has been generalized in DSmT for any regular bbam(.) :G
Θ
P
7→ [0, 1] (i.e. such thatm(∅) = 0 and X∈G
Θm(X) = 1) and for any model of the frame (free DSm model, hybrid DSm model and Shafer's model as well)
[6]. It is given by **BetP**(∅) = 0 and∀X∈G
Θ **\ {∅}** by

$$B e t P(X)=\sum_{Y\in G^{\Theta}}\frac{{\mathcal{C}}_{{\mathcal{M}}}(X\cap Y)}{{\mathcal{C}}_{{\mathcal{M}}}(Y)}m(Y)\qquad\qquad(3)$$

whereG
Θ corresponds to the hyper-power set including all the integrity constraints of the model (if any)
2;CM(Y) denotes the DSm cardinal 3 of the setY . The formula (3) reduces to (1)
whenG
Θ reduces to classical power set2 Θ when one adopts Shafer's model. 

1We assume thatm(.) is of course a non degenerate bba, i.e.m(∅)6= 1.

2G
Θ = 2 Θ if one adopts Shafer's model forΘ andG
Θ=D
Θ (Dedekind's lattice) if one adopts the free DSm model forΘ [6].

3CM
(Y) is the number of parts ofY in the Venn diagram of the model M of the frameΘ under consideration [6] (Chap. 7).

arXiv:0807.3669v1 [cs.AI] 23 Jul 2008