where [x] means the closest integer to x (with [n +
0.5] = n + 1, ∀n ∈ N). This operator is justified by the approximation of the product of equidistant labels given by Li· Lj =i n+1 ·j n+1 =
(i·j)/(n+1)
n+1 .

- Scalar multiplication of a linguistic label: Let a be a real number. The multiplication of a linguistic label by a scalar is defined by:

$$a\cdot L_{i}={\frac{a\cdot i}{n+1}}\approx\begin{cases}L_{[a\cdot i]}&{\mathrm{if~}}[a\cdot i]\geq0,\\ L_{-[a\cdot i]}&{\mathrm{otherwise}}.\end{cases}$$
$$(17)$$

- Division of linguistic labels:
a) q-division as an internal operator: Let j 6= 0, then

$$L_{i}/L_{j}=\begin{cases}L_{[(i/j)\cdot(n+1)]}&\text{if}[(i/j)\cdot(n+1)]<n+1,\\ L_{n+1}&\text{otherwise}.\end{cases}\tag{18}$$
The first equality in (18) is well justified because with equidistant labels, one gets: Li/Lj =
  **Case with quantum actions, one goal $L_{1}/L_{j}=\frac{i/(n+1)}{j/(n+1)}=\frac{(i/j)\cdot(n+1)}{n+1}\approx L_{[(i/j)\cdot(n+1)]}$.** **b) Division as an external operator: $\oslash$. Let $j\neq0$. We define:**  $$L_{i}\oslash L_{j}=i/j.\tag{19}$$  **since for equidistant labels $L_{i}\oslash L_{j}=(i/(n+1))/(j/(n+1))=i/j$.**  **for** $\cdot$**. When working with labels no matter how many
Remark: When working with labels, no matter how many operations we have, the best (most accurate) result is obtained if we do only one approximation, and that one should be just at the very end.

## C. More Operations With Labels

On the interval [0, 1] we consider the labels Li, 0 ≤ i ≤
n + 1, n ≥ 0 such that Li = i/(n + 1). But we extend this closed interval to the right and to the left in order to be able to do all needed label operations in any fusion calculation.

Therefore Ln+2 = n+2 n+1 , Ln+3 = n+3 n+1 , . . . and respectively L−i = −Li =−i n+1 , so we get L−1, L−2, . . . . In general Li = i/(n + 1) for any i ∈ Z = {. . . , −2, −1, 0, 1, 2**, . . .**}
where Z is the set of all integers. Now we define four more operators involving labels.

1) Addition of labels with real scalars: If r ∈ R (the set of real numbers) and i ∈ Z, then:

$$L_{i}+r=r+L_{i}=L_{[i+r(n+1)]}$$

where [x] means the closest integer to x. This operator is justified because Li + r =i n+1 + r =
i+r(n+1)
n+1 ≈ L[i+r(n**+1)]**
and it is needed in the qualitative extension of DSmP formula.

2) Subtraction between labels and real scalars:

$$L_{i}-r=L_{[i-r(n+1)]}\tag{21}$$  because $L_{i}-r=\frac{i}{n+1}-r=\frac{i-r(n+1)}{n+1}\approx L_{[i-r(n+1)]}$ and similarly $r-L_{i}=L_{[r(n+1)-i]}$ because $r-L_{i}=r-\frac{i}{n+1}=\frac{r(n+1)-i}{n+1}\approx L_{[r(n+1)-i]}$.  
3) & 4) Powers and roots of labels:

$$(L_{i})^{k}=L_{[\frac{ik}{(n+1)^{k-1}}]}\tag{22}$$  for $k\in\mathbb{R}$ because $(L_{i})^{k}=(\frac{i}{n+1})^{k}=\frac{\frac{i^{k}}{(n+1)^{k-1}}}{n+1}\approx L_{[\frac{ik}{(n+1)^{k-1}}]}$.  
$$(23)$$
If k ∈ Q, which is the set of fractions (rational numbers),
we get the radical operation of labels. Therefore,
$$\sqrt[p]{L_{i}}=L_{\lfloor\sqrt[p]{i.(n+1)^{p-1}}\rfloor}$$  because we replace $k=1/p$ in the formula (22).  
D. Quasi-normalization of qm(.)
There is no way to define a normalized qm(.), but a qualitative quasi-normalization [7] is nevertheless possible when considering equidistant linguistic labels because in such case, qm(Xi) = Li, is equivalent to a quantitative mass m(Xi) = i/(n + 1) which is normalized if:

$$\sum_{X\in G^{\Theta}}m(X)=\sum_{k}i_{k}/(n+1)=1,$$  but this one is equivalent to:  $$\sum_{X\in G^{\Theta}}qm(X)=\sum_{k}L_{i_{k}}=L_{n+1}.$$

In this case, we have a *qualitative normalization*, similar to the (classical) numerical normalization. But, if the labels L0, L1, L2, **. . .**, Ln, Ln+1 are not equidistant, so the interval [0, 1]
cannot be split into equal parts according to the distribution of the labels, then it makes sense to consider a *qualitative* quasi-normalization, *i.e.* an approximation of the (classical) numerical normalization for the qualitative masses in the same way:

$$\sum_{X\in G^{\Theta}}q m(X)=L_{n+1}.$$

In general, if we don't know if the labels are equidistant or not, we say that a qualitative mass is quasi-normalized when the above summation holds.

E. Qualitative extension of DSmP
The qualitative extension of (11), denoted **qDSmP**(.) is given by **qDSmP**ǫ(∅) = 0 and ∀X ∈ GΘ **\ {∅}** by

$$qDSmP_{\epsilon}(X)=\sum_{Y\in G^{\Theta}}\frac{\sum_{\begin{subarray}{c}Z\subseteq X\cap Y\\ \mathcal{C}(Z)=1\end{subarray}}qm(Z)+\epsilon\cdot\mathcal{C}(X\cap Y)}{\sum_{\begin{subarray}{c}Z\subseteq Y\\ \mathcal{C}(Z)=1\end{subarray}}qm(Z)+\epsilon\cdot\mathcal{C}(Y)}qm(Y)\tag{24}$$
$$(21)$$

where all operations in (24) are referred to labels, that is qoperators on linguistic labels defined in IX-B and not classical operators on numbers. In the same manner, due to our construction of labels and qualitative operators, we can transform any quantitative fusion rule (or arithmetic expression) into a qualitative fusion rule (or qualitative expression).