# Verified Null-Move Pruning

Omid David-Tabibi 1 *Nathan S. Netanyahu* 2 Ramat-Gan, Israel

## Abstract

In this article we review standard null-move pruning and introduce our extended version of it, which we call *verified null-move pruning*. In verified null-move pruning, whenever the shallow null-move search indicates a fail-high, instead of cutting off the search from the current node, the search is continued with reduced depth.

Our experiments with verified null-move pruning show that on average, it constructs a smaller search tree with greater tactical strength in comparison to standard null-move pruning. Moreover, unlike standard null-move pruning, which fails badly in zugzwang positions, verified null-move pruning manages to detect most zugzwangs and in such cases conducts a re-search to obtain the correct result. In addition, verified null-move pruning is very easy to implement, and any standard null-move pruning program can use verified null-move pruning by modifying only a few lines of code.

## 1. Introduction

Until the mid-1970s most chess programs were trying to search the same way humans think, by generating "plausible" moves. By using extensive chess knowledge at each node, these programs selected a few moves which they considered plausible, and thus pruned large parts of the search tree. However, plausible-move generating programs had serious tactical shortcomings, and as soon as brute-force search programs like TECH (Gillogly, 1972)
and CHESS 4.X (Slate and Atkin, 1977) managed to reach depths of 5 plies and more, plausible-move generating programs frequently lost to brute-force searchers due to their tactical weaknesses. Brute-force searchers rapidly dominated the computer-chess field.

Most brute-force searchers of that time used no selectivity in their full-width search tree, except for some extensions, consisting mostly of check extensions and recaptures. The most successful of these brute-force programs were BELLE (Condon and Thompson, 1983a,b), DEEPTHOUGHT (Hsu, Anantharaman, Campbell, and Nowatzyk, 1990), HITECH (Berliner and Ebeling, 1990; Berliner, 1987; Ebeling, 1986), and CRAYBLITZ (Hyatt, Gower, and Nelson, 1990), which for the first time managed to compete successfully against humans.

The introduction of null-move pruning (Beal, 1989; Goetsch and Campbell, 1990; Donninger, 1993) in the early 1990s marked the end of an era, as far as the domination of brute-force programs in computer chess is concerned. Unlike other forward-pruning methods (e.g., *razoring* (Birmingham and Kent, 1977), GAMMA (Newborn, 1975), and *marginal forward pruning* (Slagle, 1971)), which had great tactical weaknesses, null-move pruning enabled programs to search more deeply with minor tactical risks. Forward-pruning programs frequently outsearched bruteforce searchers, and started their own reign which has continued ever since; they have won all World ComputerChess Championships since 1992 (van den Herik and Herschberg, 1992; Tsang and Beal, 1995; Feist, 1999). DEEP BLUE (Hammilton and Garber, 1997; Hsu, 1999) (the direct descendant of DEEP THOUGHT (Hsu *et al.*, 1990))
was probably the last brute-force searcher. Today almost all top-tournament playing programs use forward-pruning methods, null-move pruning being the most popular of them (Feist, 1999). 1Department of Computer Science, Bar-Ilan University, Ramat-Gan 52900, Israel, Email: mail@omiddavid.com, Web:
http://www.omiddavid.com. 2Department of Computer Science, Bar-Ilan University, Ramat-Gan 52900, Israel, Email: nathan@cs.biu.ac.il, and Center for Automation Research, University of Maryland, College Park, MD 20742, USA, Email: nathan@cfar.umd.edu.