In this article we introduce our new *verified null-move pruning* method, and demonstrate empirically its improved performance in comparison with standard null-move pruning. This is reflected in its reduced search tree size, as well as its greater tactical strength. In Section 2 we review standard null-move pruning, and in Section 3 we introduce verified null-move pruning. Section 4 presents our experimental results, and Section 5 contains concluding remarks.

## 2. Standard Null-Move Pruning

As mentioned earlier, brute-force programs refrained from pruning any nodes in the full-width part of the search tree, deeming the risks of doing so as being too high. Null-move (Beal, 1989; Goetsch and Campbell, 1990; Donninger, 1993) introduced a new pruning scheme which based its cutoff decisions on dynamic criteria, and thus gained greater tactical strength in comparison with the static forward pruning methods that were in use at that time.

Null-move pruning is based on the following assumption: in every chess position, doing nothing (i.e., doing a null move) would not be the best choice even if it were a legal option. In other words, the best move in any position is better than the null move. This idea enables us easily to obtain a lower bound α on the position by conducting a null-move search. We make a null move, i.e., we merely swap the side whose turn it is to move. (Note that this cannot be done in positions where that side is in check, since the resulting position would be illegal. Also, two null moves in a row are forbidden, since they result in nothing.) We then conduct a regular search with reduced depth and save the returned value. This value can be treated as a lower bound on the position, since the value of the best (legal) move has to be better than that obtained from the null move. If this value is greater than or equal to the current upper bound (i.e., value ≥ β), it results in a cutoff (or what is called a fail-high). Otherwise, if it is greater than the current lower bound α, we define a narrower search window, as the returned value becomes the new lower bound. If the value is smaller than the current lower bound, it does not contribute to the search in any way. The main benefit of null-move pruning is due to the cutoffs, which result from the returned value of null-move search being greater than the current upper bound. Thus, the best way to apply null-move pruning is by conducting a minimal-window null-move search around the current upper bound β, since such a search will require a reduced search effort to determine a cutoff. A typical null-move pruning implementation is given by the pseudo-code of Figure 1.

![0_image_0.png](0_image_0.png)

There are positions in chess where any move will deteriorate the position, so that not making a move is the best option. These positions are called *zugzwang* positions. While zugzwang positions are rare in the middle game, they are not an exception in endgames, especially endgames in which one or both sides are left with King and Pawns. Null-move pruning will fail badly in zugzwang positions since the basic assumption behind the method does not hold. In fact, the null-move search's value is an upper bound in such cases. As a result, null-move pruning is avoided in such endgame positions.