As previously noted, the major benefit of null-move pruning stems from the depth reduction in the null-move searches. However, these reduced-depth searches are liable to tactical weaknesses due to the *horizon effect*
(Berliner, 1974). A horizon effect results whenever the reduced-depth search misses a tactical threat. Such a threat would not have been missed, had we conducted a search without any depth reduction. The greater the depth reduction R, the greater the tactical risk due to the horizon effect. So, the saving resulting from null-move pruning depends on the depth reduction factor, since a shallower search (i.e., a greater R) will result in faster null-move searches and an overall smaller search tree.

In the early days of null-move pruning, most programs used R = 1, which ensures the least tactical risk, but offers the least saving in comparison with other R values. Other reduction factors that were experimented with were R = 2 and R = 3. Research conducted over the years, most extensively by Heinz (1999), showed that overall, R = 2 performs better than the too conservative R = 1 and the too aggressive R = 3. Today, almost all null-move pruning programs, use at least R = 2 (Feist, 1999). However, using R = 3 is tempting, considering the reduced search effort resulting from shallower null-move searches. (This will be demonstrated in Section 4.) Donninger
(1993) was the first to suggest an adaptive rather than a fixed value for R. Experiments conducted by Heinz (1999),
in his article on adaptive null-move pruning, suggest that using R = 3 in upper parts of the search tree and R = 2 in its lower parts can save 10 to 30 percent of the search effort in comparison with a fixed R = 2, while maintaining overall tactical strength.

In the next section we present a new null-move pruning method which allows the use of R = 3 in all parts of the search tree, while alleviating to a significant extent the main disadvantage of standard null-move pruning.

## 3. Verified Null-Move Pruning

Cutoffs based on a shallow null-move search can be too risky at some points, especially in zugzwang positions. Goetsch and Campbell (1990) hinted at continuing the search with reduced depth, in case the null-move search indicates a fail-high, in order to substantiate that the value returned from the null-move search is indeed a lower bound on the position. Plenkner (1995) showed that this idea can help prevent errors due to zugzwangs. However, verifying the search in the middle game seems wasteful, as it appears to undermine the basic benefit of null-move pruning, namely that a cutoff is determined by a shallow null-move search.

In addition to helping in detecting zugzwangs, the idea of not immediately pruning the search tree (based on the value returned from the shallow null-move search) can also help to reduce the tactical weaknesses caused by the horizon effect, since by continuing the search we may be able to detect threats which the shallow null-move search has failed to detect. Based on these ideas, we developed our own reformulation, which we call verified null-move pruning. At each node, we conduct a null-move search with a depth reduction of R = 3. If the returned value from that null-move search indicates a fail-high (i.e., value ≥ β), we then reduce the depth by one ply and continue the search in order to verify the cutoff. However, for that node's subtree, we use standard null-move pruning (cutoff takes place upon fail-highs). See Figure 2, for an illustration.

![0_image_0.png](0_image_0.png)

