fail-high, we reduce the depth and continue the search, using standard null-move pruning (with R = 3) in that node's subtree. The search at a node is thus cut off (based on its null-move search) only if there has been another null-move search fail-high indication in one of the node's ancestors (see Figure 2). As the experimental results in the next section show, verified null-move pruning constructs a search tree which is close in size to that of standard null-move pruning with R = 3, and whose tactical strength is greater on average than that of standard null-move pruning with R = 2. This is a smaller search tree with greater tactical strength, in comparison with standard null-move pruning with R = 2, which is commonly used nowadays.

Since upon a fail-high indication we do not cut off the search at once, we have the ability to check whether the returned value is indeed a lower bound on the position. If the null-move search indicates a cutoff, but the search shows that the best value is smaller than β, this implies that the position is a zugzwang, as the value from the null move is greater than or equal to the value from the best move. In such cases, we restore the original depth (which was reduced by one ply after the fail-high indication), and conduct a re-search to obtain the correct value.

Implementation of verified null-move search is a matter of adding a few lines of code to standard null-move search, as shown in Figure 3. Regarding the pseudo-code presented, when the search starts at the root level, the flag verify is initialized to true. When the null-move search indicates a fail-high, the remaining depth is reduced by one ply, and verify is given the value false, which will be passed to the children of the current node, indicating that standard null-move pruning will be conducted with respect to the children. Upon a fail-high indication due to the standard null-move search of these children's subtrees, cutoff takes place immediately.

## 4. Experimental Results

In this section we examine the performance of verified null-move pruning, focusing on its tactical strength and smaller search-tree size in comparison with standard null-move pruning. We conducted our experiments using the GENESIS3engine. GENESIS is designed especially for research, emphasizing accurate implementation of algorithms and detailed statistics. For our experiments we used the NEGASCOUT/PVS (Campbell and Marsland, 1983; Reinefeld, 1983) search algorithm, with history heuristic (Schaeffer, 1983, 1989) and transposition table (Slate and Atkin, 1977; Nelson, 1985). To demonstrate the tactical strength differences between the different methods even better, we used one-ply check extensions on leaf nodes; the quiescence search consisted only of captures/recaptures. In all test suites used, we discarded positions in which at least one side had no more than King and Pawns. This was done to avoid dealing with zugzwang positions, for which verified null-move pruning obviously fares much better tactically, as explained before.

In order to obtain an estimate of the search tree, we searched 138 test positions from *Test Your Tactical Ability* by Yakov Neishtadt (see the Appendix) to depths of 9 and 10 plies, using standard R = 1, R = 2, R = 3, and verified R = 3. Table 1 gives the total node count for each method and the size of the tree in comparison with verified R = 3. Table 2 gives the number of positions that each method solved correctly (i.e., found the correct variation for). Later we will further examine the tactical strength, using additional test suites.

| Depth                                                                                                           | Std R = 1      | Std R = 2     | Std R = 3   | Vrfd R = 3    |
|-----------------------------------------------------------------------------------------------------------------|----------------|---------------|-------------|---------------|
| 9                                                                                                               | 1,652,668,804  | 603,549,661   | 267,208,422 | 449,744,588   |
| (+267.46%)                                                                                                      | (+34.19%)      | (-40.58%)     | -           |               |
| 10                                                                                                              | 11,040,766,367 | 1,892,829,685 | 862,153,828 | 1,449,589,289 |
| (+661.64%)                                                                                                      | (+30.57%)      | (-40.52%)     | -           |               |
| Table 1: Total node count of standard R = 1, 2, 3 and verified R = 3 at depths 9 and 10, for 138 Neishtadt test |                |               |             |               |

The results in Tables 1 and 2 reveal that the size of the tree constructed by verified null-move pruning is between those of standard R = 2 and R = 3, and that its tactical strength is greater on average than that of standard R = 2. These results also show that the use of R = 1 is impractical due to its large tree size in comparison with other depth-reduction values. Focusing on the practical alternatives (i.e., standard R = 2 and R = 3, and verified R = 3), we would like to examine the behavior of verified R = 3 and find out whether its tree size remains between the tree sizes associated with R = 2 and R = 3, or whether it approaches the size of one of 3http://www.omiddavid.com/genesis