
| Depth                                                                                                          | Std R = 2      | Std R = 3     | Vrfd R = 3    |
|----------------------------------------------------------------------------------------------------------------|----------------|---------------|---------------|
| 8                                                                                                              | 783,461,647    | 533,282,695   | 906,225,552   |
| (-13.55%)                                                                                                      | (-41.15%)      | -             |               |
| 9                                                                                                              | 3,742,064,688  | 1,316,719,980 | 2,539,057,043 |
| (+47.38%)                                                                                                      | (-48.14%)      | -             |               |
| 10                                                                                                             | 11,578,143,939 | 4,871,295,877 | 7,889,544,754 |
| (+46.75%)                                                                                                      | (-38.26%)      | -             |               |
| Table 4: Total node count of standard R = 2, R = 3 and verified R = 3 at depths 8, 9, and 10, for 999 WCS test |                |               |               |

| Depth                                                                                                        | Std R = 2   | Std R = 3   | Vrfd R = 3   |
|--------------------------------------------------------------------------------------------------------------|-------------|-------------|--------------|
| 8                                                                                                            | 762         | 760         | 782          |
| 9                                                                                                            | 838         | 812         | 838          |
| 10                                                                                                           | 850         | 849         | 866          |
| Table 5: Number of solved positions using R = 2, R = 3 and verified R = 3 at depths 8, 9, and 10 for 999 WCS |             |             |              |

| Test Suite                                                                                                     | Std R = 1   | Std R = 2   | Std R = 3   | Vrfd R = 3   |
|----------------------------------------------------------------------------------------------------------------|-------------|-------------|-------------|--------------|
| "Mate in 4"                                                                                                    | 433         | 385         | 379         | 431          |
| Depth 8 plies "Mate in 5"                                                                                      | 347         | 292         | 286         | 340          |
| Depth 10 plies                                                                                                 |             |             |             |              |
| Table 6: Numbers of solved positions using standard R = 1, 2, 3 and verified R = 3 for 434 "mate in 4" and 353 |             |             |             |              |

The results in Tables 5 and 6 indicate that verified null-move pruning solved far more positions than standard nullmove pruning with depth reductions of R = 2 and R = 3. This demonstrates that not only does verified null-move pruning result in a reduced search effort (the constructed search tree is closer in size to that of standard R = 3), but its tactical strength is greater than that of standard R = 2, which is the common depth reduction value.

Finally, to study the overall advantage of verified null-move pruning over standard null-move pruning in practice, we conducted 100 self-play games, using two versions of the GENESIS engine, one with verified R = 3 and the other with standard R = 2. The time control was set to 60 minutes per game. The version using verified R = 3 scored 68.5 out of 100 (see the Appendix), which demonstrates the superiority of verified null-move pruning over the standard version.

## 5. Conclusion

In this article we introduced a new null-move pruning method which outperforms standard null-move pruning techniques, in terms of reducing the search tree size as well as gaining greater tactical strength. The idea of not cutting off the search as soon as the shallow null-move search indicates a fail-high allows verification of the cutoff, which results in greater tactical accuracy and prevents errors due to zugzwangs. We showed empirically that verified null-move pruning with a depth reduction of R = 3 constructs a search tree which is closer in size to that of the tree constructed by standard R = 3, and that the saving from the reduced search effort in comparison with standard R = 2 becomes greater as we search more deeply. We also showed that on average, the tactical strength of verified null-move pruning is greater than that of standard null-move pruning with R = 2. Moreover, verified null-move pruning can be implemented within any standard null-move pruning framework by merely adding a few lines of code.

We considered a number of variants of standard null-move pruning. The first variant was not to cut off at all upon fail-high reports, but rather reduce the depth by 2 plies. We obtained good results with this idea, but its tactical strength was sometimes smaller than that of standard R = 2. We concluded that in order to improve the results, the depth should not be reduced by more than one ply at a time upon fail-high reports. An additional variant was not to cut off at any node, not even in the subtree of a node with a fail-high report, but merely to reduce the depth