# Randomised Variable Neighbourhood Search For Multi Objective Optimisation Martin Josef Geiger

School of Computer Science & IT, University of Nottingham, mjg@cs.nott.ac.uk

## Abstract 1

Various local search approaches have recently been applied to machine scheduling problems under multiple objectives. **Their**
foremost consideration is the identification of the set of Pareto optimal alternatives. An important aspect of successfully solving these problems lies in the definition of an appropriate neighbourhood structure. Unclear in this context remains, how interdependencies within the fitness landscape affect the resolution of the problem.

The paper presents a study of neighbourhood search operators for multiple objective flow shop scheduling. Experiments have been carried out with twelve different combinations of criteria. To derive exact conclusions, small problem instances, for which the optimal solutions are known, have been chosen. **Statistical tests show that no single neighbourhood operator is**
able to equally identify all Pareto optimal alternatives. Significant improvements however have been obtained by hybridising the solution algorithm using a randomised variable neighbourhood search technique. Keywords: **Hybrid Local Search, Multi Objective Optimisation, Flow Shop Scheduling.**

## 1 Introduction

Machine scheduling considers in general the assignment of a set of resources (machines) M = {M1, . . . , Mm} **to a**
set of jobs J = {J1, . . . , Jn}, each of which consists of a set of operations Jj = {Oj1, . . . , Ojoj } **[5]. The operations**
Ojk typically may be processed on a single machine Mi ∈ M involving a nonnegative processing time tjk**. Usually,**
precedence constraints are defined among the operations of a job, reflecting its technical nature. In the specific case of the here considered permutation flow shop scheduling problem**, the machine sequences are identical for all** jobs [21]. Furthermore, the sequence of the jobs on the machines **is assumed to be the same, therefore leading to a**
single job permutation as a possible schedule representation. A solution of the problem, a schedule**, defines starting** times for the tasks respecting the chosen job sequence and the defined constraints of the problem.

Optimality of schedules can be judged with respect to a single or multiple objective functions, expressing the quality of the solution in a quantitative way. While the multi criteria nature of scheduling in manufacturing environments has been mentioned quite early [24], the problem is treated **only recently as a multi objective optimisation**
problem [30]. Here, the goal is to identify all efficient alternatives, the set of Pareto optimal solutions P **[31]. Most**
important optimality criteria are based on the completion times Cj of the jobs Jj **in the schedule:**
- The minimisation of the maximum completion time (makespan) Cmax = max{C1**, . . . , C**n}.

- The minimisation of the sum of the completion times Csum =Pn j=1 Cj In the case of existing due dates dj for each job Jj **, it is possible to compute due date violations in the form of** tardiness values Tj = max{Cj − dj , 0}**. Possible optimality criteria are:**
- The minimisation of the maximum tardiness Tmax = max{T1**, . . . , T**j}.

- The minimisation of the total tardiness Tsum =Pn j=1 Tj .

arXiv:0809.0271v1 [cs.AI] 1 Sep 2008