
## 2. Solving The Multi-Objective Permutation Flow Shop Scheduling Problem By Metaheuristics 2.1. Problem Description

The flow shop scheduling problem consists in the assignment of a set of jobs J = {J1**, . . . J**n}, each of which consists of a set of operations Jj = {Oj1**, . . . , O**joj } onto a set of machines M = {M1**, . . . , M**m}
(Bła˙zewicz, Ecker, Pesch, Schmidt and We¸glarz, 2001; Pinedo, 2002). Each operation Ojk is processed by at most one machine at a time, involving a non-negative processing time pjk. The result of the problem resolution is a schedule x, defining for each operation Ojk a starting time sjk on the corresponding machine.

Several side constraints are present which have to be respected by any solution x belonging to the set of feasible schedules X. Precedence constraints Ojk ⊲ Ojk+1∀j = 1, . . . , n, k = 1**, . . . , o**j − 1 between the operations of a job Jj assure that processing of Ojk+1 only commences after completion of Ojk, thus sjk+1 > sjk + pjk. In flow shop scheduling, the machine sequence in which the operations are processed by the machines is identical for all jobs, and for the specific case of the permutation flow shop scheduling the job sequence must also be the same on all machines. The assignment of operations to machines has to be done with respect to one or several optimality criteria.

Most optimality criteria are functions of the completion times Cj of the jobs Jj , with the computation as given in Expression (1).

Cj = sjoj + pjoj(1)
The most prominent is the maximum completion time (makespan) Cmax, computed in the following Expression (2).

Cmax **= max** Cj (2)
Others express violations of due dates dj of jobs Jj . A due date dj defines a latest point of time until a job Jj should be finished as the assembled product has to be delivered to the customer on this date. The computation of an occurring tardiness Tj of a job Jj is given in Expression (3). A possible optimality criteria based on tardiness of jobs is e. g. the total tardiness Tsum as given in Expression (4).

$$T_{j}=\max(C_{j}-d_{j},0)$$ $$T_{sum}=\sum T_{j}$$
$$\mathrm{i)}$$
$$\mathbf{\partial})$$

It is known, that for *regular* optimality criteria at least one *active* schedule x does exist which is also optimal (Baker, 1974). As the representation of an active schedule for the permutation flow shop scheduling problem is possible using a permutation of jobs π = (π1**, . . . , π**n), where each πj stores a job Jk at position j, this way of representing alternatives is often used in resolution approaches. The search is then restricted to the much smaller set of active schedules only.

Multi-objective approaches to scheduling consider a vector G(x) = (g1(x)**, . . . , g**K(x)) of optimality criteria at once (T'kindt and Billaut, 2002). As the relevant optimality criteria are often of conflicting nature, not a single solution x ∈ X exists optimizing all components of G(x) at once. Optimality in multi-objective optimization problems is therefore understood in the sense of Pareto-optimality, and the resolution of multiobjective optimization problems lies in the identification of all elements belonging to the Pareto set P,
containing all alternatives x which are not dominated by any other alternative x
′ ∈ X. The corresponding definitions are given in Definition 1 and 2. Without loss of generality we assume the minimization of the optimality criteria gi(x)∀i = 1**, . . . , K**.

Definition 1 (Dominance) *A vector* G(x), x ∈ X *is said to dominate a vector* G(x
′
), x′ ∈ X *if and only if* gi(x) 6 gi(x
′
) ∧ ∃i | gi(x) < gi(x
′
). We denote the dominance of a G(x) *over* G(x
′
) *with* G(x)  G(x
′
).

Definition 2 (Pareto-optimality, Pareto set) *An alternative* **x, x** ∈ X is called Pareto-optimal if and only if 6 ∃x
′ ∈ X | G(x
′
)  G(x). The corresponding vector G(x) of a Pareto-optimal alternative is called efficient, the set of all Pareto-optimal alternatives is called the Pareto set P.