# A Computational Study Of Genetic Crossover Operators For Multi-Objective Vehicle Routing Problem With Soft Time Windows

Martin Geiger University of Hohenheim, Production and Operations Management Department, 70593 Stuttgart, Germany Abstract. The article describes an investigation of the effectiveness of genetic algorithms for multi-objective combinatorial optimization **(MOCO) by presenting an**
application for the vehicle routing problem with soft time windows. The work is motivated by the question, if and how the problem structure influences the effectiveness of different configurations of the genetic algorithm. Computational results are presented for different classes of vehicle routing problems, varying in their coverage with time windows, time window size, distribution and **number of customers.**
The results are compared with a simple, but effective local search approach for multi-objective combinatorial optimization problems.

## 1 Introduction

The requirements of modern logistics are widespread. It seems natural that for practical problems several objectives have to be optimized. The quality of service and products and the corresponding cost are only a small subset of necessary objectives that should be considered [25]. The distribution of products, a part of the supply chain in logistics, can be modelled as a vehicle routing problem (VRP). The objective is to find a costminimizing set of routes from a depot to serve a number of customers with known demands. Each customer is serviced by exactly one of the vehicles which capacities are not allowed to be exceeded.

The model of the vehicle routing problem with time windows (VRPTW) generalizes the basic problem by introducing time windows for each customer, defining an earliest and a latest possible time of service. In the case of the vehicle routing problem with soft time windows (VRPSTW), violation of these time windows is possible and does not lead to infeasibility of the solution
[1]. In our approach, the possible violations of the time windows are modelled by introducing objective functions, leading to a multi-objective **model**
that is able to describe the requirements of practical problems more detailed compared to single-criterion optimization approaches. The goal is to find all solutions minimizing the defined objective functions. As these functions are often conflicting, the concept of Pareto optimality is used to determine appropriate solutions.

The VRPTW [31], as well as the VRP [23], has been shown to be NP-hard in