# Genetic Algorithms For Multiple Objective Vehicle Routing

M.J. Geiger ∗
∗ **Production and Operations Management**
Institute 510 - Business Administration University of Hohenheim Email: mail@martingeiger.de

## Abstract

The talk describes a general approach of a genetic algorithm **for multiple objective optimization**
problems. A particular dominance relation between the individuals of the population is used to define a fitness operator, enabling the genetic algorithm to adress even problems with efficient, but convex-dominated alternatives. The algorithm is implemented in a multilingual computer program, solving vehicle routing problems with time windows under multiple objectives. The graphical user interface of the program shows the progress of the genetic algorithm and the main parameters of the approach can be easily modified. In addition to that, the program provides powerful decision support to the decision maker. The software has proved it´s excellence at the finals of the European Academic Software Award EASA, held at the Keble college/ University of Oxford/ Great Britain.

## 1 The Genetic Algorithm For Multiple Objective Optimization Problems

Based on a single objective genetic algorithm, different extensions for multiple objective optimization problems are proposed in literature [1, 4, 8, 10] All of them tackle the multiple objective elements by modifying the evaluation and selection operator of the genetic algorithm. Compared to a single objective problem, more than one evaluation functions are considered and the fitness of the individuals cannot be directly calculated from the (one) objective value.

Efficient but convex-dominated alternatives are difficult to obtain by **integrating the considered**
objectives to a weighted sum (Figure 1). To overcome this problem, **an approach of a selection-operator** is presented, using only few information and providing a underlying self-adaption technique.

In this approach, we use dominance-information of the individuals of **the population by calculating**
for each individual i the number of alternatives ξi **from which this individual is dominated. For a** population consisting of npop **alternatives we get values of:**

0 ≤ ξi ≤ npop − 1 (1)
Individuals that are not being dominated by others should receive a higher fitness value than individuals that are being dominated, i.e.:

if $\xi_{i}=\xi_{j}\to f(i)=f(j)\quad\forall i,j=1,\ldots,n_{pop}$.  
if ξi < ξj → f(i) > f(j) ∀i, j = 1, . . . , npop (2)
if ξi = ξj → f(i) = f(j) ∀i, j = 1, . . . , npop (3)
arXiv:0809.0416v1 [cs.AI] 2 Sep 2008