# A Framework For The Interactive Resolution Of Multi-Objective Vehicle Routing Problems

Martin Josef Geiger and Wolf Wenger∗

## Abstract

The article presents a framework for the resolution of rich vehicle routing problems which are difficult to address with standard optimization techniques. We use local search on the basis on variable neighborhood search for the construction of the solutions, but embed the techniques in a flexible framework that allows the consideration of complex side constraints of the problem such as time windows, multiple depots, heterogeneous fleets, and, in particular, multiple optimization criteria. In order to identify a compromise alternative that meets the requirements of the decision maker, an interactive procedure is integrated in the resolution of the problem, allowing the modification of the preference information articulated by the decision maker. The framework is prototypically implemented in a computer system. First results of test runs on multiple depot vehicle routing problems with time windows are reported.

Keywords: **User-guided search, interactive optimization, multi-objective optimization, multi depot vehicle**
routing problem with time windows, variable neighborhood search.

## 1 Introduction

The vehicle routing problem (VRP) is one of the classical optimization problems known from operations research with numerous applications in real world logistics. In brief, a given set of customers has to be served with vehicles from a depot such that a particular criterion is optimized. The most comprehensive model therefore consists of a complete graph G = (V, A**), where** V = {v0, v1, . . . , vn}
denotes a set of vertices and A = {(vi, vj ) | vi, vj ∈ V, i 6= j} **denotes the connecting arcs. The**
depot is represented by v0, and m **vehicles are stationed at this location to service the customers**
vi, . . . , vn. Each customer vi demands a nonnegative quantity qi **of goods and service results in a**
nonnegative service time di**. Traveling on a connecting arc (**vi, vj ) results in a cost cij **or travel time**
tij **. The most basic vehicle routing problem aims to identify a solutions that serves all customers,**
not exceeding the maximum capacity of the vehicles Qk and their maximum travel time Tk **while**
minimizing the total distances/costs of the routes.

Various extensions have been proposed to this general problem type. Most of them introduce additional constraints to the problem domain such as time windows, defining for each customer vi **an interval [**ei, li] of service. While arrival before ei **results in a waiting time, arrival after** liis
∗**Lehrstuhl f¨ur Industriebetriebslehre, Universit¨at Hohenheim, 70593 Stuttgart, Germany**
Email: {mjgeiger|w-wenger}@uni-hohenheim.de