The results reveal significant differences between the instances. While we have been able to always assign all events to timeslots for instance comp01.ctt and comp04.ctt, comp05.ctt **turns out to be particularly difficult (constrained). After not having been**
able to identify a single constructive run in which all events have been assigned to timeslots, we conclude that simply relying on more repetitions is most probably insufficient for this instance. We rather need to adapt the constructive methodology to the particular instance, overcoming problems with the assignment of events to timeslots.

## 3.3 Reactive Repetitive Reconstruction The Method

Based on the initial constructive approach, we propose a reactive procedure that adapts to the set of unassigned events from previous runs. The logic **behind this approach is** that the constructive procedure 'discovers' events that are difficult to assign, giving them priority in successive runs. Similar ideas have been sketched by the **squeaky**
wheel optimization approach [6], and implemented in ant colony metaheuristics for examination timetabling problems [4].

In the following, let E
p **be the set of prioritized events,** E
¬p**the set of non-prioritized**
events, and E
u**the set events that have not been assigned during the construction phase.**
It is required that E
p ⊆ E, E
¬p ⊆ E, E
p ∩ E¬p = ∅**, and** E
p ∪ E¬p = E.

Algorithm 2 describes the reactive construction procedure.

Algorithm 2 **Reactive construction**
1: Set E
p = ∅, E
u = ∅, **loops** = 0 2: **repeat**
3: E
p ← Eu 4: E
u ← ∅
5: E
¬p **← E\E**p 6: **while** E
p 6= ∅ do 7: Select the most critical event E from E
p, that is the event with the smallest number of available timeslots 8: if E can be assigned to at least one timeslot **then** 9: Select some available timeslot T for E
10: Assign E to the timeslot T
11: **else**
12: E
u ← Eu ∪ E
13: **end if**
14: E
p ← Ep\E
15: **end while**
16: **while** E
¬p 6= ∅ do 17: Select the most critical event E from E
¬p, that is the event with the smallest number of available timeslots 18: if E can be assigned to at least one timeslot **then**
19: Select some available timeslot T for E
20: Assign E to the timeslot T
21: **else**
22: E
u ← Eu ∪ E
23: **end if**
24: E
¬p ← E¬p\E
25: **end while**
26: loops ← **loops** + 1 27: **until** E
u = ∅ or loops = Maxloops 5