As given in the pseudo-code, the construction of solutions is carried out in a loop until either a feasible solution is identified or a maximum number of iterations **Maxloops**
is reached. When constructing a solution, a set of events E
u**is kept for which no timeslot has been found. When reconstructing a solution, these events are prioritized over**
the others. In that sense, the constructive approach is biased by its previous runs, identifying events that turn out to be difficult to assign.

After at most a maximum number of Maxloops **iterations, the construction procedure returns a solution that is either feasible (**E
u = ∅**) or not (**E
u6= ∅).

It has been pointed out that even when events are put into E
p, they do not necessarily remain elements of that set. Instead, they might be **removed from** E
p**in the**
subsequent loop. To some extent, this is counterintuitive, **as the algorithm does not**
build up a complete datastructure storing all **unsuccessfully assigned events. Instead,**
the direct 'learning' is limited to the preceding run. It has **to be mentioned however,**
that some implicit information is nevertheless transferred from loop to loop, as any loop is biased by its predecessor. It also should be noticed that this implementation of a more limited adaptive algorithm led to satisfactory results, which is why alternative approaches have not been further investigated yet.

Experimental results In the experiments, we focused on the difficult instance comp05.ctt**, computing for**
1000 trials the number of feasible solutions reached after a **certain number of loops of** the constructive approach. The obtained results are given in Table 2.

Table 2 Feasible solutions after a certain number of loops for comp05.ctt (out of 1,000 trials)

| Loops   | feasible solutions   |
|---------|----------------------|
| 1       | 0                    |
| 2       | 56                   |
| 3       | 272                  |
| 4       | 387                  |
| 5       | 511                  |
| 6       | 608                  |
| 7       | 688                  |
| 8       | 754                  |
| 9       | 802                  |
| 10      | 831                  |

The number of cases in which a feasible solution has been reached slowly converges to 1000, monotonically increasing with each additional loop. This indicates that the biased reconstruction in the presented approach successfully adapts to events which are difficult to assign to timeslots.

It should be noticed that the behavior of the approach for the **other benchmark**
instances is similar. This observation is however less important, as a repetitive application of the simple constructive approach will increase the percentage of cases in which a feasible solution is reached, too. For instance comp05.ctt**, where not a single feasible**
solution is found after the first loop, this does not hold.

6