
## 1 Introduction

An integral part of a successful completion of most university studies is the participation in seminars within which a written report on a given scientific subject has to be produced and handed in by a student. The topics are usually proposed by members of staff that also support the work carried out by the students. For many departments the assignment of students to topics and therefore to lecturers is a recurring task that usually has to be carried out once per term. In practice, the assignment is done with respect to a set of aspects combining **preferences of students/lecturers as**
well as balancing the workload of staff.

Although the precise situation studied in the work presented here has not been tackled in literature before, similar problems are available in the context of course assignment and faculty assignment**. The general problem there lies in assigning teachers to courses with respect to a set of**
side constraints and personal preferences [8]. Most quantitative formulations are based on integer linear programming models [1] and solved using commercially available software packages [6]. Other resolution methods used are based on genetic algorithms [7] **or model explicit knowledge taken from**
human experts [5] in order to solve the problem.

Problems in the mentioned area have already quite early been **considered to employ multiple**
criteria [3] as preferences of a set of persons have to be met at once and therefore require the identification of a compromise solution. While goal programming here plays an important role, another methodology that has been successfully applied in the past is the Analytic Hierarchy Process AHP [4].

The paper is organized as follows. In the following section 2, the problem of assigning students to topics/lecturers is explained and formulated as studied **in the real world case at the University** of Hohenheim. Section 3 presents a study of local search approaches used to solve the problem at hand. Experiments are carried out on a set of problem instances, one of them taken from the real world situation and others generated on the basis of the practical case. Conclusions are derived in section 4.