very large benchmark instances, that is, smodels programs having up to millions of rules. The concluding remarks of this paper are presented in Section 7.

## 2 Modularity Aspects Of Logic Programming

Bugliesi et al. (1994) address several properties that are expected from a modular logic programming language. For instance, a modular language should
- allow abstraction, parameterization, and information hiding, - ease program development and maintenance of large programs,
- allow re-usability
- have a non-trivial notion of program equivalence to justify replacement of program components, and
- maintain the declarativity of logic programming.

Two mainstream programming disciplines are identified. In programming-in-thelarge approaches programs are composed with algebraic operators, see for instance
(O'Keefe 1985; Mancarella and Pedreschi 1988; Gaifman and Shapiro 1989; Brogi et al. 1994). In programming-in-lhe-small approaches abstraction mechanisms are used, see for instance (Miller 1989; Giordano and Martelli 1994).

The programming-in-the-large approaches have their roots in the framework proposed by O'Keefe (1985) where logic programs are seen as elements of an algebra and the operators for composing programs are seen as operators in that algebra . The fundamental idea is that a logic program should be understood as a part of a system of programs. Program composition is a powerful tool for structuring programs without any need to extend the underlying language of Horn clauses. Several algebraic operations such as union, deletion, overriding union and closure have been considered. This approach supports naturally the re-use of the pieces of programs in different composite programs, and when combined with an adequate equivalence relation also the replacement of equivalent components. This approach is highly flexible, as new composition mechanisms can be obtained by introducing a corresponding operator in the algebra or combining existing ones. Encapsulation and information hiding can be obtained by introducing suitable interfaces for componnts.

The programming-in-the-small approaches originate from (Miller 1989). In this approach the composition of modules is modelled in terms of logical connectives of a language that is defined as an extension of Horn clause logic . The approach in (Giordano and Martelli 1994) employs the same structural properties, but suggests a more refined way of modelling visibility rules than the one in (Miller 1989).

It is essential that a semantical characterization of a modular language is such that the meaning of composite programs can be defined in terms of the meaning of its components (Maher 1993). To be able to identify when it is safe to substitute a module with another without affecting the global behavior it is crucial to have a notion of semantical equivalence . More formally these desired properties can be described under the terms of compositionality and full abstraction (Gaifman and Shapiro 1989; Meyer 1988). 4